/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.base.OwnershipTab;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class OwnershipClientTab
extends TraderInterfaceClientTab<OwnershipTab> {
    EditBox newOwnerInput;
    Button buttonSetOwner;
    TeamSelectWidget teamSelection;
    Button buttonSetTeamOwner;
    UUID selectedTeam = null;
    List<Team> teamList = Lists.newArrayList();
    IconButton buttonToggleMode;
    boolean playerMode = true;

    public OwnershipClientTab(TraderInterfaceScreen screen, OwnershipTab tab) {
        super(screen, tab);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.settings.owner");
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void onOpen() {
        this.newOwnerInput = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 26, 160, 20, (Component)new TextComponent("")));
        this.newOwnerInput.m_94199_(16);
        this.buttonSetOwner = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 47, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.set_owner"), this::setOwner));
        this.buttonSetOwner.f_93623_ = false;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 13, this.screen.getGuiTop() + 25, 4, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.font);
        this.buttonSetTeamOwner = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 23, this.screen.getGuiTop() + 117, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.set_owner"), this::setTeamOwner));
        this.buttonSetTeamOwner.f_93623_ = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 20 - 3, this.screen.getGuiTop() + 3, this::toggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)this::getModeIcon), (Button.OnTooltip)new IconAndButtonUtil.ToggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)new TranslatableComponent("tooltip.lightmanscurrency.settings.owner.player"), (Component)new TranslatableComponent("tooltip.lightmanscurrency.settings.owner.team"))));
        this.tick();
    }

    private IconData getModeIcon() {
        return this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of((ItemLike)Items.f_42614_);
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam == null) {
            return null;
        }
        return ClientTradingOffice.getTeam(this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = ClientTradingOffice.getTeamList();
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.menu.getBE() == null) {
            return;
        }
        this.font.m_92889_(pose, TextRenderUtil.fitString((Component)new TranslatableComponent("gui.button.lightmanscurrency.team.owner", new Object[]{this.menu.getBE().getOwnerName()}), this.screen.getXSize() - 20), (float)(this.screen.getGuiLeft() + 10), (float)(this.screen.getGuiTop() + 10), 0x404040);
    }

    public boolean changeInTrades() {
        TradeData referencedTrade = this.menu.getBE().getReferencedTrade();
        TradeData trueTrade = this.menu.getBE().getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        if (this.menu.getBE() == null) {
            return;
        }
        if (this.buttonSetOwner.m_5953_((double)mouseX, (double)mouseY) || this.buttonSetTeamOwner.m_5953_((double)mouseX, (double)mouseY)) {
            this.screen.m_96602_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.warning").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), mouseX, mouseY);
        }
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleMode}));
    }

    private void toggleMode(Button button) {
        this.playerMode = !this.playerMode;
    }

    private void setOwner(Button button) {
        if (this.newOwnerInput.m_94155_().isBlank()) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewOwner(this.newOwnerInput.m_94155_());
        this.newOwnerInput.m_94144_("");
    }

    private void setTeamOwner(Button button) {
        if (this.selectedTeam == null) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewTeam(this.selectedTeam);
        this.selectedTeam = null;
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID().equals(this.selectedTeam) ? null : newTeam.getID();
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.newOwnerInput.m_94120_();
        this.buttonSetOwner.f_93624_ = this.newOwnerInput.f_93624_ = this.playerMode;
        this.teamSelection.f_93624_ = !this.playerMode;
        this.buttonSetTeamOwner.f_93624_ = this.teamSelection.f_93624_;
        this.buttonSetOwner.f_93623_ = !this.newOwnerInput.m_94155_().isBlank();
        this.buttonSetTeamOwner.f_93623_ = this.getSelectedTeam() != null;
    }

    @Override
    public void onClose() {
        this.selectedTeam = null;
        this.teamList = Lists.newArrayList();
    }
}

