/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.UniversalTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.base.TraderSelectTab;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class TraderSelectClientTab
extends TraderInterfaceClientTab<TraderSelectTab>
implements ScrollBarWidget.IScrollable {
    EditBox searchField;
    ScrollBarWidget scrollBar;
    List<UniversalTraderButton> traderButtons;
    private int scroll;
    private List<UniversalTraderData> filteredTraderList = new ArrayList<UniversalTraderData>();

    public TraderSelectClientTab(TraderInterfaceScreen screen, TraderSelectTab tab) {
        super(screen, tab);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModBlocks.TERMINAL.get());
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.interface.trader");
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private List<UniversalTraderData> traderList() {
        List<UniversalTraderData> traderList = this.filterTraders(ClientTradingOffice.getTraderList());
        traderList.sort(TradingTerminalScreen.TERMINAL_SORTER);
        return traderList;
    }

    private List<UniversalTraderData> filterTraders(List<UniversalTraderData> allTraders) {
        ArrayList<UniversalTraderData> traders = new ArrayList<UniversalTraderData>();
        TraderInterfaceBlockEntity be = this.menu.getBE();
        if (be == null) {
            return traders;
        }
        TraderInterfaceBlockEntity.InteractionType interaction = be.getInteractionType();
        for (UniversalTraderData trader : allTraders) {
            if (!be.validTraderType(trader) || (!interaction.trades || !trader.hasValidTrade()) && (!interaction.requiresPermissions || !trader.hasPermission(this.menu.getBE().getReferencedPlayer(), "interactionLink"))) continue;
            traders.add(trader);
        }
        return traders;
    }

    @Override
    public void onOpen() {
        this.searchField = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + 43, this.screen.getGuiTop() + 6, 101, 9, (Component)new TranslatableComponent("gui.lightmanscurrency.terminal.search")));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.initTraderButtons(this.screen.getGuiLeft(), this.screen.getGuiTop());
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 30 + 146, this.screen.getGuiTop() + 18, 120, this));
        this.tick();
        this.updateTraderList();
        UniversalTraderData selectedTrader = this.menu.getBE().getTrader();
        if (selectedTrader != null) {
            this.scroll = this.scrollOf(selectedTrader);
            this.updateTraderButtons();
        }
        this.screen.addTabListener(new ScrollListener(0, 0, this.screen.f_96543_, this.screen.f_96544_, this::onMouseScrolled));
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<UniversalTraderButton>();
        for (int y = 0; y < 4; ++y) {
            UniversalTraderButton newButton = this.screen.addRenderableTabWidget(new UniversalTraderButton(guiLeft + 30, guiTop + 18 + y * 30, this::SelectTrader, this.font));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.m_93228_(pose, this.screen.getGuiLeft() + 28, this.screen.getGuiTop() + 4, 0, 236, 117, 12);
        this.scrollBar.beforeWidgetRender(mouseY);
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.searchField.m_94120_();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            UniversalTraderButton button = this.traderButtons.get(i);
            button.selected = button.getData() != null && button.getData() == ((TraderInterfaceMenu)this.screen.m_6262_()).getBE().getTrader();
        }
    }

    @Override
    public boolean charTyped(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    private void SelectTrader(Button button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            UUID traderID = this.filteredTraderList.get(index).getTraderID();
            ((TraderSelectTab)this.commonTab).setTrader(traderID);
        }
    }

    private int getTraderIndex(Button button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += this.scroll;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(this.filteredTraderList.size() - this.traderButtons.size(), 0);
    }

    private int scrollOf(UniversalTraderData trader) {
        if (this.filteredTraderList != null) {
            int index = this.filteredTraderList.indexOf(trader);
            if (index >= 0) {
                return Math.min(index, this.getMaxScroll());
            }
            return this.scroll;
        }
        return this.scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = TradingOffice.filterTraders(this.searchField.m_94155_(), this.traderList());
        this.updateTraderButtons();
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.min(newScroll, this.getMaxScroll());
        this.updateTraderButtons();
    }

    private boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll < this.getMaxScroll()) {
                this.setScroll(this.scroll + 1);
            }
        } else if (delta > 0.0 && this.scroll > 0) {
            this.setScroll(this.scroll - 1);
        }
        return false;
    }
}

