/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.MessageAddPersistentAuction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;

public class AuctionCreateClientTab
extends TraderStorageClientTab<AuctionCreateTab> {
    public static final long CLOSE_DELAY = 5000L;
    public static final long MAX_DAY_COUNT = 30L;
    AuctionTradeData pendingAuction;
    TradeButton tradeDisplay;
    CoinValueInput priceSelect;
    Button buttonTogglePriceMode;
    boolean startingBidMode = true;
    long auctionCreated = 0L;
    Button buttonIncreaseHour;
    Button buttonDecreaseHour;
    Button buttonIncreaseDay;
    Button buttonDecreaseDay;
    private int dayCount;
    private int hourCount;
    Button buttonSubmitAuction;
    boolean locked = false;
    long successTime = 0L;
    Button buttonSubmitPersistentAuction;
    EditBox persistentAuctionIDInput;

    public AuctionCreateClientTab(TraderStorageScreen screen, AuctionCreateTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_PLUS;
    }

    public MutableComponent getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.auction.create");
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return TradingOffice.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
    }

    @Override
    public void onOpen() {
        this.pendingAuction = new AuctionTradeData(this.menu.player);
        this.dayCount = Math.max(1, (Integer)Config.SERVER.minAuctionDuration.get());
        this.hourCount = 0;
        this.updateDuration();
        this.locked = false;
        this.successTime = 0L;
        this.startingBidMode = true;
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getContext, () -> this.pendingAuction, b -> {}));
        this.tradeDisplay.move(this.screen.getGuiLeft() + 15, this.screen.getGuiTop() + 5);
        this.priceSelect = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + this.screen.getXSize() / 2 - 88, this.screen.getGuiTop() + 34, (Component)new TextComponent(""), CoinValue.EMPTY, this.font, this::onPriceChanged, this.screen::addRenderableTabWidget));
        this.priceSelect.init();
        this.priceSelect.allowFreeToggle = false;
        this.priceSelect.drawBG = false;
        this.buttonTogglePriceMode = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 114, this.screen.getGuiTop() + 5, this.screen.getXSize() - 119, 20, (Component)new TranslatableComponent("button.lightmanscurrency.auction.toggleprice.startingbid"), b -> this.TogglePriceTarget()));
        ((AuctionCreateTab)this.commonTab).getAuctionItems().m_19164_(c -> this.UpdateAuctionItems());
        this.buttonIncreaseDay = this.screen.addRenderableTabWidget(new PlainButton(this.screen.getGuiLeft() + 80, this.screen.getGuiTop() + 112, 20, 10, b -> this.changeDayCount(1), CoinValueInput.GUI_TEXTURE, 0, 69));
        this.buttonDecreaseDay = this.screen.addRenderableTabWidget(new PlainButton(this.screen.getGuiLeft() + 80, this.screen.getGuiTop() + 135, 20, 10, b -> this.changeDayCount(-1), CoinValueInput.GUI_TEXTURE, 20, 69));
        this.buttonIncreaseHour = this.screen.addRenderableTabWidget(new PlainButton(this.screen.getGuiLeft() + 110, this.screen.getGuiTop() + 112, 20, 10, b -> this.changeHourCount(1), CoinValueInput.GUI_TEXTURE, 0, 69));
        this.buttonDecreaseHour = this.screen.addRenderableTabWidget(new PlainButton(this.screen.getGuiLeft() + 110, this.screen.getGuiTop() + 135, 20, 10, b -> this.changeHourCount(-1), CoinValueInput.GUI_TEXTURE, 20, 69));
        this.buttonSubmitAuction = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 40, this.screen.getGuiTop() - 20, this.screen.getXSize() - 80, 20, (Component)new TranslatableComponent("button.lightmanscurrency.auction.create"), b -> this.submitAuction()));
        this.buttonSubmitAuction.f_93623_ = false;
        this.buttonSubmitPersistentAuction = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 20, this.screen.getGuiTop() - 20, this::submitPersistentAuction, IconAndButtonUtil.ICON_PERSISTENT_DATA, (Button.OnTooltip)IconAndButtonUtil.TOOLTIP_PERSISTENT_AUCTION));
        this.buttonSubmitPersistentAuction.f_93624_ = TradingOffice.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
        this.buttonSubmitPersistentAuction.f_93623_ = false;
        int idWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.settings.persistent.id"));
        this.persistentAuctionIDInput = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + idWidth + 2, this.screen.getGuiTop() - 40, this.screen.getXSize() - idWidth - 2, 18, (Component)new TextComponent("")));
        this.persistentAuctionIDInput.f_93624_ = TradingOffice.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player);
    }

    @Override
    public void onClose() {
        ((AuctionCreateTab)this.commonTab).getAuctionItems().m_19181_(c -> this.UpdateAuctionItems());
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            this.screen.m_93228_(pose, this.screen.getGuiLeft() + slot.f_40220_ - 1, this.screen.getGuiTop() + slot.f_40221_ - 1, 206, 0, 18, 18);
        }
        this.font.m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.auction.auctionitems"), (float)(this.screen.getGuiLeft() + 15 + 7), (float)(this.screen.getGuiTop() + 112), 0x404040);
        TextRenderUtil.drawCenteredText(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.auction.duration.day", new Object[]{this.dayCount}), this.screen.getGuiLeft() + 90, this.screen.getGuiTop() + 124, 0x404040);
        TextRenderUtil.drawCenteredText(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.auction.duration.hour", new Object[]{this.hourCount}), this.screen.getGuiLeft() + 120, this.screen.getGuiTop() + 124, 0x404040);
        if (this.locked && this.successTime != 0L) {
            TextRenderUtil.drawCenteredText(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.auction.create.success").m_130940_(ChatFormatting.BOLD), this.screen.getGuiLeft() + this.screen.getXSize() / 2, 34, 0x404040);
        }
        if (TradingOffice.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player)) {
            this.font.m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.settings.persistent.id"), (float)this.screen.getGuiLeft(), (float)(this.screen.getGuiTop() - 35), 0xFFFFFF);
        }
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(pose, mouseX, mouseY);
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonSubmitPersistentAuction}));
    }

    @Override
    public void tick() {
        this.priceSelect.locked = this.locked;
        this.priceSelect.tick();
        if (this.locked && this.successTime != 0L && TimeUtil.compareTime(5000L, this.successTime)) {
            this.screen.changeTab(0);
            return;
        }
        if (this.locked) {
            this.buttonSubmitAuction.f_93623_ = false;
            this.buttonIncreaseHour.f_93623_ = false;
            this.buttonDecreaseHour.f_93623_ = false;
            this.buttonIncreaseDay.f_93623_ = false;
            this.buttonDecreaseDay.f_93623_ = false;
            this.buttonTogglePriceMode.f_93623_ = false;
        } else {
            this.buttonTogglePriceMode.f_93623_ = true;
            if (this.dayCount >= (Integer)Config.SERVER.maxAuctionDuration.get()) {
                this.buttonIncreaseHour.f_93623_ = false;
                this.buttonIncreaseDay.f_93623_ = false;
            } else {
                this.buttonIncreaseHour.f_93623_ = true;
                this.buttonIncreaseDay.f_93623_ = true;
            }
            this.buttonDecreaseDay.f_93623_ = this.dayCount > (Integer)Config.SERVER.minAuctionDuration.get();
            this.buttonDecreaseHour.f_93623_ = this.dayCount > (Integer)Config.SERVER.minAuctionDuration.get() || this.hourCount > 1;
            this.buttonSubmitAuction.f_93623_ = this.pendingAuction.isValid();
        }
        if (TradingOffice.isAdminPlayer(((TraderStorageMenu)this.screen.m_6262_()).player)) {
            this.persistentAuctionIDInput.f_93624_ = !this.locked;
            this.buttonSubmitPersistentAuction.f_93624_ = this.persistentAuctionIDInput.f_93624_;
            this.buttonSubmitPersistentAuction.f_93623_ = this.pendingAuction.isValid();
            this.persistentAuctionIDInput.m_94120_();
        } else {
            this.persistentAuctionIDInput.f_93624_ = false;
            this.buttonSubmitPersistentAuction.f_93624_ = false;
        }
    }

    private void UpdateAuctionItems() {
        this.pendingAuction.setAuctionItems((Container)((AuctionCreateTab)this.commonTab).getAuctionItems());
    }

    private void onPriceChanged(CoinValue newPrice) {
        if (this.startingBidMode) {
            this.pendingAuction.setStartingBid(newPrice);
        } else {
            this.pendingAuction.setMinBidDifferent(newPrice);
        }
    }

    private void TogglePriceTarget() {
        this.startingBidMode = !this.startingBidMode;
        this.buttonTogglePriceMode.m_93666_((Component)new TranslatableComponent(this.startingBidMode ? "button.lightmanscurrency.auction.toggleprice.startingbid" : "button.lightmanscurrency.auction.toggleprice.mindeltabid"));
        if (this.startingBidMode) {
            this.priceSelect.setCoinValue(this.pendingAuction.getLastBidAmount());
        } else {
            this.priceSelect.setCoinValue(this.pendingAuction.getMinBidDifference());
        }
    }

    private void changeHourCount(int delta) {
        this.hourCount += delta;
        if (this.hourCount < 0) {
            if (this.dayCount > (Integer)Config.SERVER.minAuctionDuration.get()) {
                this.hourCount += 24;
                this.changeDayCount(-1);
                return;
            }
            this.hourCount = this.dayCount > 0 ? 0 : 1;
        }
        if (this.hourCount >= 24) {
            int addToDays = this.hourCount / 24;
            this.hourCount %= 24;
            this.changeDayCount(addToDays);
        } else {
            this.updateDuration();
        }
    }

    private void changeDayCount(int delta) {
        this.dayCount = MathUtil.clamp(this.dayCount + delta, 0, (Integer)Config.SERVER.maxAuctionDuration.get());
        if (this.dayCount < 1 && this.hourCount < 1) {
            this.dayCount = 1;
        }
        if (this.dayCount < (Integer)Config.SERVER.minAuctionDuration.get()) {
            this.dayCount = (Integer)Config.SERVER.minAuctionDuration.get();
        }
        if (this.dayCount >= (Integer)Config.SERVER.maxAuctionDuration.get()) {
            this.hourCount = 0;
        }
        this.updateDuration();
    }

    private void updateDuration() {
        this.pendingAuction.setDuration((long)this.dayCount * 86400000L + (long)this.hourCount * 3600000L);
    }

    private void submitAuction() {
        ((AuctionCreateTab)this.commonTab).createAuction(this.pendingAuction);
        this.locked = true;
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            slot.locked = true;
        }
    }

    private void submitPersistentAuction(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddPersistentAuction(this.pendingAuction.getAsNBT(), this.persistentAuctionIDInput.m_94155_()));
    }

    @Override
    public void receiveServerMessage(CompoundTag message) {
        if (message.m_128441_("AuctionCreated")) {
            if (message.m_128471_("AuctionCreated")) {
                this.successTime = TimeUtil.getCurrentTime();
            } else {
                this.locked = false;
                for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
                    slot.locked = false;
                }
            }
        }
    }
}

