/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.auction.AuctionStorageTab;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AuctionStorageClientTab
extends TraderStorageClientTab<AuctionStorageTab>
implements ScrollListener.IScrollListener,
ScrollBarWidget.IScrollable {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 10;
    private static final int ROWS = 4;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    Button buttonCollectItems;
    IconButton buttonCollectMoney;

    public AuctionStorageClientTab(TraderStorageScreen screen, AuctionStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.auction.storage");
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 180, this.screen.getGuiTop() + 17, 72, this));
        this.buttonCollectItems = this.screen.addRenderableTabWidget(IconAndButtonUtil.quickExtractButton(this.screen.getGuiLeft() + 11, this.screen.getGuiTop() + 17 + 72 + 8, b -> ((AuctionStorageTab)this.commonTab).quickTransfer()));
        this.buttonCollectMoney = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + 25, this.screen.getGuiTop() + 118, b -> ((AuctionStorageTab)this.commonTab).collectCoins(), IconAndButtonUtil.ICON_COLLECT_COINS));
        this.screen.addTabListener(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getXSize(), 118, this));
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.font.m_92889_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.storage"), (float)(this.screen.getGuiLeft() + 8), (float)(this.screen.getGuiTop() + 6), 0x404040);
        this.scrollBar.beforeWidgetRender(mouseY);
        if (this.menu.getTrader() instanceof AuctionHouseTrader) {
            this.validateScroll();
            int index = this.scroll * 10;
            AuctionPlayerStorage storage = ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player);
            if (storage != null) {
                List<ItemStack> storedItems = storage.getStoredItems();
                int hoverSlot = this.isMouseOverSlot(mouseX, mouseY) + this.scroll * 10;
                for (int y = 0; y < 4 && index < storedItems.size(); ++y) {
                    int yPos = this.screen.getGuiTop() + 17 + y * 18;
                    for (int x = 0; x < 10 && index < storedItems.size(); ++index, ++x) {
                        int xPos = this.screen.getGuiLeft() + 13 + x * 18;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.screen.m_93228_(pose, xPos, yPos, 206, 0, 18, 18);
                        if (index < storedItems.size()) {
                            ItemRenderUtil.drawItemStack((GuiComponent)this.screen, this.font, storedItems.get(index), xPos + 1, yPos + 1);
                        }
                        if (index != hoverSlot) continue;
                        AbstractContainerScreen.m_169606_((PoseStack)pose, (int)(xPos + 1), (int)(yPos + 1), (int)this.screen.m_93252_());
                    }
                }
                if (storedItems.size() <= 0) {
                    TextRenderUtil.drawCenteredMultilineText(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.storage.items.none"), this.screen.getGuiLeft() + 10, this.screen.getXSize() - 20, this.screen.getGuiTop() + 13 + 36, 0x404040);
                }
                boolean bl = this.buttonCollectItems.f_93623_ = storedItems.size() > 0;
                if (storage.getStoredCoins().hasAny()) {
                    this.buttonCollectMoney.f_93623_ = true;
                    this.font.m_92889_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.storage.money", new Object[]{storage.getStoredCoins().getString("0")}), (float)(this.screen.getGuiLeft() + 50), (float)(this.screen.getGuiTop() + 118), 0x404040);
                } else {
                    this.buttonCollectMoney.f_93623_ = false;
                    this.font.m_92889_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.auction.storage.money.none"), (float)(this.screen.getGuiLeft() + 50), (float)(this.screen.getGuiTop() + 118), 0x404040);
                }
            }
        }
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        AuctionPlayerStorage storage;
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && ((TraderStorageMenu)this.screen.m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0 && (hoveredSlot += this.scroll * 10) < (storage = ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player)).getStoredItems().size()) {
            ItemStack stack = storage.getStoredItems().get(hoveredSlot);
            this.screen.m_96597_(pose, ItemRenderUtil.getTooltipFromItem(stack), mouseX, mouseY);
        }
    }

    private void validateScroll() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 10 && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(leftEdge + x * 18)) || !(mouseX < (double)(leftEdge + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 4 && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(topEdge + y * 18)) || !(mouseY < (double)(topEdge + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 10 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getTrader() instanceof AuctionHouseTrader) {
            return ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player).getStoredItems().size();
        }
        return 0;
    }

    private boolean canScrollDown() {
        return this.totalStorageSlots() - this.scroll * 10 > 40;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0) {
            ((AuctionStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 10, Screen.m_96638_());
            return true;
        }
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 10 - 4 + 1, 0);
    }
}

