/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.MessageAddPersistentTrader;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class MainTab
extends SettingsTab {
    public static final MainTab INSTANCE = new MainTab();
    EditBox nameInput;
    Button buttonSetName;
    Button buttonResetName;
    PlainButton buttonToggleBankLink;
    IconButton buttonToggleCreative;
    Button buttonAddTrade;
    Button buttonRemoveTrade;
    Button buttonSavePersistentTrader;
    EditBox persistentTraderIDInput;
    EditBox persistentTraderOwnerInput;

    private MainTab() {
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of();
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.nameInput = screen.addRenderableTabWidget(new EditBox(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 25, 160, 20, (Component)new TextComponent("")));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(coreSettings.getCustomName());
        this.buttonSetName = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 50, 74, 20, (Component)new TranslatableComponent("gui.lightmanscurrency.changename"), this::SetName));
        int n = screen.guiLeft();
        Objects.requireNonNull(screen);
        this.buttonResetName = screen.addRenderableTabWidget(new Button(n + 200 - 93, screen.guiTop() + 50, 74, 20, (Component)new TranslatableComponent("gui.lightmanscurrency.resetname"), this::ResetName));
        int n2 = screen.guiLeft() + 176;
        int n3 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonToggleCreative = screen.addRenderableTabWidget(IconAndButtonUtil.creativeToggleButton(n2, n3 + 200 - 30, this::ToggleCreative, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getScreen().getSetting(CoreTraderSettings.class).isCreative())));
        int n4 = screen.guiLeft() + 166;
        int n5 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonAddTrade = screen.addRenderableTabWidget(new PlainButton(n4, n5 + 200 - 30, 10, 10, this::AddTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 200));
        int n6 = screen.guiLeft() + 166;
        int n7 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonRemoveTrade = screen.addRenderableTabWidget(new PlainButton(n6, n7 + 200 - 20, 10, 10, this::RemoveTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 220));
        this.buttonToggleBankLink = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 100, 10, 10, this::ToggleBankLink, TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220));
        this.buttonToggleBankLink.f_93624_ = screen.hasPermission("bankLink");
        if (this.getScreen().getTrader() instanceof UniversalTraderData) {
            int n8 = screen.guiLeft() + 10;
            int n9 = screen.guiTop();
            Objects.requireNonNull(screen);
            this.buttonSavePersistentTrader = screen.addRenderableTabWidget(new IconButton(n8, n9 + 200 - 30, this::SavePersistentTraderData, IconAndButtonUtil.ICON_PERSISTENT_DATA, (Button.OnTooltip)IconAndButtonUtil.TOOLTIP_PERSISTENT_TRADER));
            this.buttonSavePersistentTrader.f_93624_ = TradingOffice.isAdminPlayer(this.getPlayer());
            int idWidth = this.getFont().m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.settings.persistent.id"));
            Font font = this.getFont();
            int n10 = screen.guiLeft() + 37 + idWidth;
            int n11 = screen.guiTop();
            Objects.requireNonNull(screen);
            this.persistentTraderIDInput = screen.addRenderableTabWidget(new EditBox(font, n10, n11 + 200 - 30, 108 - idWidth, 18, (Component)new TextComponent("")));
            int ownerWidth = this.getFont().m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.settings.persistent.owner"));
            Font font2 = this.getFont();
            int n12 = screen.guiLeft() + 12 + ownerWidth;
            int n13 = screen.guiTop();
            Objects.requireNonNull(screen);
            this.persistentTraderOwnerInput = screen.addRenderableTabWidget(new EditBox(font2, n12, n13 + 200 - 55, 178 - ownerWidth, 18, (Component)new TextComponent("")));
        }
        this.tick();
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        screen.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.customname"), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 15), 0x404040);
        if (screen.hasPermission("bankLink")) {
            this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.settings.banklink"), (float)(screen.guiLeft() + 32), (float)(screen.guiTop() + 101), 0x404040);
        }
        if (TradingOffice.isAdminPlayer(this.getScreen().getPlayer())) {
            String count = String.valueOf(screen.getTrader().getTradeCount());
            int width = this.getFont().m_92895_(count);
            Font font = this.getFont();
            float f = screen.guiLeft() + 164 - width;
            int n = screen.guiTop();
            Objects.requireNonNull(screen);
            font.m_92883_(pose, count, f, (float)(n + 200 - 25), 0x404040);
            if (this.persistentTraderIDInput != null) {
                Font font2 = this.getFont();
                TranslatableComponent translatableComponent = new TranslatableComponent("gui.lightmanscurrency.settings.persistent.id");
                float f2 = screen.guiLeft() + 35;
                int n2 = screen.guiTop();
                Objects.requireNonNull(screen);
                font2.m_92889_(pose, (Component)translatableComponent, f2, (float)(n2 + 200 - 25), 0xFFFFFF);
                Font font3 = this.getFont();
                TranslatableComponent translatableComponent2 = new TranslatableComponent("gui.lightmanscurrency.settings.persistent.owner");
                float f3 = screen.guiLeft() + 10;
                int n3 = screen.guiTop();
                Objects.requireNonNull(screen);
                font3.m_92889_(pose, (Component)translatableComponent2, f3, (float)(n3 + 200 - 50), 0xFFFFFF);
            }
        }
    }

    @Override
    public void postRender(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        IconAndButtonUtil.renderButtonTooltips(matrix, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleCreative, this.buttonSavePersistentTrader}));
        if (this.buttonAddTrade.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.creative.addTrade"), mouseX, mouseY);
        } else if (this.buttonRemoveTrade.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.creative.removeTrade"), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        boolean canLinkAccount;
        boolean isAdmin;
        boolean canChangeName = this.getScreen().hasPermission("changeName");
        this.nameInput.m_94186_(canChangeName);
        this.nameInput.m_94120_();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.buttonSetName.f_93623_ = !this.nameInput.m_94155_().contentEquals(coreSettings.getCustomName());
        this.buttonSetName.f_93624_ = canChangeName;
        this.buttonResetName.f_93623_ = coreSettings.hasCustomName();
        this.buttonResetName.f_93624_ = canChangeName;
        this.buttonToggleCreative.f_93624_ = isAdmin = TradingOffice.isAdminPlayer(this.getPlayer());
        if (this.buttonToggleCreative.f_93624_) {
            ITrader trader = this.getScreen().getTrader();
            this.buttonAddTrade.f_93624_ = true;
            this.buttonAddTrade.f_93623_ = trader.getTradeCount() < 32;
            this.buttonRemoveTrade.f_93624_ = true;
            this.buttonRemoveTrade.f_93623_ = trader.getTradeCount() > 1;
        } else {
            this.buttonAddTrade.f_93624_ = false;
            this.buttonRemoveTrade.f_93624_ = false;
        }
        this.buttonToggleBankLink.f_93624_ = canLinkAccount = this.getScreen().hasPermission("bankLink");
        if (canLinkAccount) {
            this.buttonToggleBankLink.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220);
            boolean bl = this.buttonToggleBankLink.f_93623_ = coreSettings.canLinkBankAccount() || coreSettings.isBankAccountLinked();
        }
        if (this.buttonSavePersistentTrader != null) {
            this.buttonSavePersistentTrader.f_93624_ = isAdmin;
            if (this.getScreen().getTrader() instanceof UniversalTraderData) {
                UniversalTraderData trader = (UniversalTraderData)this.getScreen().getTrader();
                this.buttonSavePersistentTrader.f_93623_ = trader.hasValidTrade();
            }
        }
        if (this.persistentTraderIDInput != null) {
            this.persistentTraderIDInput.f_93624_ = isAdmin;
            this.persistentTraderIDInput.m_94120_();
        }
        if (this.persistentTraderOwnerInput != null) {
            this.persistentTraderOwnerInput.f_93624_ = isAdmin;
            this.persistentTraderOwnerInput.m_94120_();
        }
    }

    @Override
    public void closeTab() {
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModItems.TRADING_CORE.get());
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.settings.name");
    }

    private void SetName(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        String customName = coreSettings.getCustomName();
        if (!customName.contentEquals(this.nameInput.m_94155_())) {
            CompoundTag updateInfo = coreSettings.setCustomName(this.getPlayer(), this.nameInput.m_94155_());
            coreSettings.sendToServer(updateInfo);
        }
    }

    private void ResetName(Button button) {
        this.nameInput.m_94144_("");
        this.SetName(button);
    }

    private void ToggleCreative(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleCreative(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void ToggleBankLink(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleBankAccountLink(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void AddTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(true);
    }

    private void RemoveTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(false);
    }

    private void SavePersistentTraderData(Button button) {
        try {
            ITrader t = this.getScreen().getTrader();
            if (t instanceof UniversalTraderData) {
                UniversalTraderData trader = (UniversalTraderData)t;
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddPersistentTrader(trader.getTraderID(), this.persistentTraderIDInput.m_94155_(), this.persistentTraderOwnerInput.m_94155_()));
            }
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error saving trader to Json.", e);
        }
    }
}

