/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageEditTeam;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class TeamMemberEditTab
extends TeamTab {
    public static final TeamMemberEditTab INSTANCE = new TeamMemberEditTab();
    ScrollTextDisplay memberDisplay;
    EditBox memberNameInput;
    Button buttonAddMember;
    Button buttonPromoteMember;
    Button buttonRemoveMember;

    private TeamMemberEditTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of(ItemRenderUtil.getAlexHead());
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.team.member_edit");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.memberNameInput = screen.addRenderableTabWidget(new EditBox(this.getFont(), screen.guiLeft() + 11, screen.guiTop() + 9, 178, 20, (Component)new TextComponent("")));
        this.memberNameInput.m_94199_(16);
        this.buttonAddMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 10, screen.guiTop() + 30, 60, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.member.add"), this::addMember));
        this.buttonPromoteMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 70, screen.guiTop() + 30, 60, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.member.promote"), this::addAdmin));
        this.buttonRemoveMember = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 130, screen.guiTop() + 30, 60, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.member.remove"), this::removeMember));
        this.buttonRemoveMember.f_93623_ = false;
        this.buttonPromoteMember.f_93623_ = false;
        this.buttonAddMember.f_93623_ = false;
        int n = screen.guiLeft() + 10;
        int n2 = screen.guiTop() + 55;
        Objects.requireNonNull(screen);
        Objects.requireNonNull(screen);
        this.memberDisplay = screen.addRenderableTabWidget(new ScrollTextDisplay(n, n2, 200 - 20, 200 - 65, this.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<Component> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            team.getAdmins().forEach(admin -> list.add(new TextComponent(admin.lastKnownName()).m_130940_(ChatFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(new TextComponent(member.lastKnownName())));
        }
        return list;
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam().isAdmin(this.getPlayer())) {
            this.buttonRemoveMember.f_93623_ = !this.memberNameInput.m_94155_().isBlank();
            this.buttonPromoteMember.f_93623_ = this.buttonRemoveMember.f_93623_;
            this.buttonAddMember.f_93623_ = this.buttonRemoveMember.f_93623_;
        } else {
            this.buttonPromoteMember.f_93623_ = false;
            this.buttonAddMember.f_93623_ = false;
            this.buttonRemoveMember.f_93623_ = PlayerReference.of(this.getPlayer()).is(this.memberNameInput.m_94155_());
        }
    }

    @Override
    public void closeTab() {
    }

    private void addMember(Button button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddMember(this.getPlayer(), this.memberNameInput.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.m_94155_(), "MEMBER"));
        this.memberNameInput.m_94144_("");
    }

    private void addAdmin(Button button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddAdmin(this.getPlayer(), this.memberNameInput.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.m_94155_(), "ADMIN"));
        this.memberNameInput.m_94144_("");
    }

    private void removeMember(Button button) {
        if (this.memberNameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeRemoveMember(this.getPlayer(), this.memberNameInput.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.memberNameInput.m_94155_(), "REMOVE"));
        this.memberNameInput.m_94144_("");
    }
}

