/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageCreateTeam;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamSelectionTab
extends TeamTab {
    public static final TeamSelectionTab INSTANCE = new TeamSelectionTab();
    TeamSelectWidget teamSelection;
    List<Team> teamList = Lists.newArrayList();
    EditBox newTeamName;
    Button buttonCreateTeam;

    private TeamSelectionTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.team.selection");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return true;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.refreshTeamList();
        this.teamSelection = screen.addRenderableTabWidget(new TeamSelectWidget(screen.guiLeft() + 10, screen.guiTop() + 20, 5, () -> this.teamList, () -> this.getActiveTeam(), this::selectTeamButton));
        this.teamSelection.init(screen::addRenderableTabWidget, this.getFont());
        this.newTeamName = screen.addRenderableTabWidget(new EditBox(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 140, 160, 20, (Component)new TextComponent("")));
        this.newTeamName.m_94199_(32);
        this.buttonCreateTeam = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 120, screen.guiTop() + 165, 60, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.create"), this::createTeam));
        this.buttonCreateTeam.f_93623_ = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = ClientTradingOffice.getTeamList();
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TeamManagerScreen screen = this.getScreen();
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.team.select"), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.team.create"), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 130), 0x404040);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonCreateTeam.f_93623_ = !this.newTeamName.m_94155_().isBlank();
    }

    @Override
    public void closeTab() {
    }

    private void selectTeamButton(int teamIndex) {
        Team team = this.getTeam(teamIndex);
        if (team != null) {
            if (this.getScreen().getActiveTeam() == team) {
                this.getScreen().setActiveTeam(null);
            } else {
                this.getScreen().setActiveTeam(team.getID());
            }
        }
    }

    private void createTeam(Button button) {
        if (this.newTeamName.m_94155_().isEmpty()) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCreateTeam(this.newTeamName.m_94155_()));
        this.newTeamName.m_94144_("");
    }
}

