/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlertData {
    private final MutableComponent message;
    public final int priority;
    public final int color;
    private final UnaryOperator<Style> formatting;

    private AlertData(MutableComponent message, int priority, int color, UnaryOperator<Style> format) {
        this.message = message;
        this.priority = priority;
        this.color = color;
        this.formatting = format;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setShaderColor(float mult) {
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)(red * mult), (float)(green * mult), (float)(blue * mult), (float)1.0f);
    }

    public MutableComponent getFormattedMessage() {
        return this.message.m_130938_(this.formatting);
    }

    public static final int compare(AlertData a, AlertData b) {
        return Integer.compare(a.priority, b.priority) * -1;
    }

    @Deprecated
    public static final AlertData convert(Component oldAlert) {
        if (oldAlert instanceof MutableComponent) {
            return AlertData.error((MutableComponent)oldAlert);
        }
        return AlertData.error((MutableComponent)new TextComponent(oldAlert.getString()));
    }

    public static final AlertData helpful(MutableComponent message) {
        return AlertData.of(message, AlertType.HELPFUL);
    }

    public static final AlertData warn(MutableComponent message) {
        return AlertData.of(message, AlertType.WARN);
    }

    public static final AlertData error(MutableComponent message) {
        return AlertData.of(message, AlertType.ERROR);
    }

    private static final AlertData of(MutableComponent message, AlertType type) {
        return AlertData.of(message, type.priority, type.color, type.format);
    }

    public static final AlertData of(MutableComponent message, int priority, int color, UnaryOperator<Style> style) {
        return new AlertData(message, priority, color, style);
    }

    public static enum AlertType {
        HELPFUL(65280, ChatFormatting.GREEN, 1),
        WARN(0xFF7F00, ChatFormatting.GOLD, 3),
        ERROR(0xFF0000, ChatFormatting.RED, 5);

        private final int priority;
        private final int color;
        private final UnaryOperator<Style> format;

        private AlertType(int color, ChatFormatting format, int priority) {
            this.color = color;
            this.format = s -> s.m_131157_(format);
            this.priority = priority;
        }
    }
}

