/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TradeButton
extends Button {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trade.png");
    public static final Button.OnPress NULL_PRESS = button -> {};
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 18;
    public static final int TEMPLATE_WIDTH = 212;
    public static final int TEMPLATE_HEIGHT = 100;
    public static final int ASSUME_HEIGHT = 18;
    private final Supplier<ITradeData> tradeSource;
    private Supplier<TradeContext> contextSource;
    public boolean displayOnly = false;

    public ITradeData getTrade() {
        return this.tradeSource.get();
    }

    public TradeContext getContext() {
        return this.contextSource.get();
    }

    public TradeButton(Supplier<TradeContext> contextSource, Supplier<ITradeData> tradeSource, Button.OnPress onPress) {
        super(0, 0, 0, 0, (Component)new TextComponent(""), onPress);
        this.tradeSource = tradeSource;
        this.contextSource = contextSource;
        this.recalculateSize();
    }

    private void recalculateSize() {
        ITradeData trade = this.getTrade();
        if (trade != null) {
            TradeContext context = this.getContext();
            this.f_93618_ = trade.tradeButtonWidth(context);
            this.f_93619_ = trade.tradeButtonHeight(context);
        }
    }

    public void move(int x, int y) {
        this.f_93620_ = x;
        this.f_93621_ = y;
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        ITradeData trade = this.getTrade();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        this.recalculateSize();
        this.renderBackground(pose, context.isStorageMode || this.displayOnly ? false : this.f_93622_);
        if (trade.hasArrow(context)) {
            this.renderArrow(pose, trade.arrowPosition(context), context.isStorageMode || this.displayOnly ? false : this.f_93622_);
        }
        try {
            trade.renderAdditional((AbstractWidget)this, pose, mouseX, mouseY, context);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error on additional Trade Button rendering.", e);
        }
        this.renderAlert(pose, trade.alertPosition(context), trade.getAlertData(context));
        this.renderDisplays(pose, trade, context);
    }

    private void renderBackground(PoseStack pose, boolean isHovered) {
        int xRend;
        int yRend;
        int xOff;
        int xRend2;
        if (this.f_93618_ < 8) {
            LightmansCurrency.LogError("Cannot render a trade button that is less than 8 pixels wide!");
            return;
        }
        if (this.f_93619_ < 8) {
            LightmansCurrency.LogError("Cannot render a trade button that is less than 8 pixels tall!");
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        if (this.f_93623_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        int vOffset = isHovered ? 100 : 0;
        this.m_93228_(pose, this.f_93620_, this.f_93621_, 0, vOffset, 4, 4);
        for (xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend2) {
            xRend2 = Math.min(this.f_93618_ - 4 - xOff, 204);
            this.m_93228_(pose, this.f_93620_ + xOff, this.f_93621_, 4, vOffset, xRend2, 4);
        }
        this.m_93228_(pose, this.f_93620_ + this.f_93618_ - 4, this.f_93621_, 208, vOffset, 4, 4);
        for (int yOff = 4; yOff < this.f_93619_ - 4; yOff += yRend) {
            int xRend3;
            yRend = Math.min(this.f_93619_ - 4 - yOff, 92);
            this.m_93228_(pose, this.f_93620_, this.f_93621_ + yOff, 0, vOffset + 4, 4, yRend);
            for (xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend3) {
                xRend3 = Math.min(this.f_93618_ - 4 - xOff, 204);
                this.m_93228_(pose, this.f_93620_ + xOff, this.f_93621_ + yOff, 4, vOffset + 4, xRend3, yRend);
            }
            this.m_93228_(pose, this.f_93620_ + this.f_93618_ - 4, this.f_93621_ + yOff, 208, vOffset + 4, 4, yRend);
        }
        this.m_93228_(pose, this.f_93620_, this.f_93621_ + this.f_93619_ - 4, 0, vOffset + 100 - 4, 4, 4);
        for (xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend) {
            xRend = Math.min(this.f_93618_ - 4 - xOff, 204);
            this.m_93228_(pose, this.f_93620_ + xOff, this.f_93621_ + this.f_93619_ - 4, 4, vOffset + 100 - 4, xRend, 4);
        }
        this.m_93228_(pose, this.f_93620_ + this.f_93618_ - 4, this.f_93621_ + this.f_93619_ - 4, 208, vOffset + 100 - 4, 4, 4);
    }

    private void renderArrow(PoseStack pose, Pair<Integer, Integer> position, boolean isHovered) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        if (this.f_93623_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        int vOffset = isHovered ? 18 : 0;
        this.m_93228_(pose, this.f_93620_ + (Integer)position.getFirst(), this.f_93621_ + (Integer)position.getSecond(), 212, vOffset, 22, 18);
    }

    private void renderAlert(PoseStack pose, Pair<Integer, Integer> position, List<AlertData> alerts) {
        if (alerts == null || alerts.size() <= 0) {
            return;
        }
        alerts.sort(AlertData::compare);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        alerts.get(0).setShaderColor(this.f_93623_ ? 1.0f : 0.5f);
        this.m_93228_(pose, this.f_93620_ + (Integer)position.getFirst(), this.f_93621_ + (Integer)position.getSecond(), 234, 0, 22, 18);
    }

    public void renderDisplays(PoseStack pose, ITradeData trade, TradeContext context) {
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(trade, context)) {
            ((DisplayEntry)display.getFirst()).render((GuiComponent)this, pose, this.f_93620_, this.f_93621_, (DisplayData)display.getSecond());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(trade, context)) {
            ((DisplayEntry)display.getFirst()).render((GuiComponent)this, pose, this.f_93620_, this.f_93621_, (DisplayData)display.getSecond());
        }
    }

    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        if (!this.f_93624_ || !this.m_5953_(mouseX, mouseY)) {
            return;
        }
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(trade, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            TradeButton.DrawTooltip(pose, mouseX, mouseY, ((DisplayEntry)display.getFirst()).tooltip);
            return;
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(trade, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            TradeButton.DrawTooltip(pose, mouseX, mouseY, ((DisplayEntry)display.getFirst()).tooltip);
            return;
        }
        if (this.isMouseOverAlert(mouseX, mouseY, trade, context)) {
            TradeButton.DrawAlerts(pose, mouseX, mouseY, trade.getAlertData(context));
            return;
        }
        TradeButton.DrawTooltip(pose, mouseX, mouseY, trade.getAdditionalTooltips(context, mouseX - this.f_93620_, mouseY - this.f_93621_));
    }

    public void onInteractionClick(int mouseX, int mouseY, int button, TradeButtonArea.InteractionConsumer consumer) {
        if (!this.f_93624_ || !this.m_5953_(mouseX, mouseY)) {
            return;
        }
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, context);
        for (int i = 0; i < inputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = inputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonInputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        List<Pair<DisplayEntry, DisplayData>> outputDisplays = TradeButton.getOutputDisplayData(trade, context);
        for (int i = 0; i < outputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = outputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonOutputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        consumer.onTradeButtonInteraction(context.getTrader(), trade, mouseX - this.f_93620_, mouseY - this.f_93621_, button);
    }

    private static void DrawTooltip(PoseStack pose, int mouseX, int mouseY, List<Component> tooltips) {
        if (tooltips == null || tooltips.size() <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91080_.m_96597_(pose, tooltips, mouseX, mouseY);
    }

    private static void DrawAlerts(PoseStack pose, int mouseX, int mouseY, List<AlertData> alerts) {
        if (alerts == null || alerts.size() <= 0) {
            return;
        }
        alerts.sort(AlertData::compare);
        ArrayList<Component> tooltips = new ArrayList<Component>();
        for (AlertData alert : alerts) {
            tooltips.add((Component)alert.getFormattedMessage());
        }
        TradeButton.DrawTooltip(pose, mouseX, mouseY, tooltips);
    }

    public int isMouseOverInput(int mouseX, int mouseY) {
        ITradeData trade = this.getTrade();
        if (trade == null) {
            return -1;
        }
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, this.getContext());
        for (int i = 0; i < inputDisplays.size(); ++i) {
            if (!((DisplayEntry)inputDisplays.get(i).getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)inputDisplays.get(i).getSecond(), mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    public int isMouseOverOutput(int mouseX, int mouseY) {
        ITradeData trade = this.getTrade();
        if (trade == null) {
            return -1;
        }
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, this.getContext());
        for (int i = 0; i < inputDisplays.size(); ++i) {
            if (!((DisplayEntry)inputDisplays.get(i).getFirst()).isMouseOver(this.f_93620_, this.f_93621_, (DisplayData)inputDisplays.get(i).getSecond(), mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    public boolean isMouseOverAlert(int mouseX, int mouseY, ITradeData trade, TradeContext context) {
        Pair<Integer, Integer> position = trade.alertPosition(context);
        int left = this.f_93620_ + (Integer)position.getFirst();
        int top = this.f_93621_ + (Integer)position.getSecond();
        return mouseX >= left && mouseX < left + 22 && mouseY >= top && mouseY < top + 18;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getInputDisplayData(ITradeData trade, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = trade.getInputDisplays(context);
        List<DisplayData> display = trade.inputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getOutputDisplayData(ITradeData trade, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = trade.getOutputDisplays(context);
        List<DisplayData> display = trade.outputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public DisplayEntry getInputDisplay(int index) {
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return DisplayEntry.EMPTY;
        }
        List<DisplayEntry> inputDisplays = trade.getInputDisplays(this.getContext());
        if (index < 0 || index >= inputDisplays.size()) {
            return DisplayEntry.EMPTY;
        }
        return inputDisplays.get(index);
    }

    private int inputDisplayCount() {
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return 0;
        }
        return trade.getInputDisplays(this.getContext()).size();
    }

    public Pair<Integer, Integer> getInputDisplayPosition(int index) {
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return Pair.of((Object)0, (Object)0);
        }
        int xPos = 0;
        int yPos = 0;
        int count = this.inputDisplayCount();
        if (index < 0 || index >= count) {
            return Pair.of((Object)0, (Object)0);
        }
        return Pair.of((Object)(this.f_93620_ + xPos), (Object)(this.f_93621_ + yPos));
    }

    public boolean isMouseOverInputDisplay(int mouseX, int mouseY, int index) {
        if (!this.f_93624_) {
            return false;
        }
        ITradeData trade = this.tradeSource.get();
        if (trade == null) {
            return false;
        }
        List<DisplayEntry> inputDisplays = trade.getInputDisplays(this.getContext());
        for (int i = 0; i < inputDisplays.size(); ++i) {
        }
        return false;
    }

    protected boolean m_7972_(int button) {
        if (this.getContext().isStorageMode || this.displayOnly) {
            return false;
        }
        return super.m_7972_(button);
    }

    public static interface ITradeData {
        public boolean isValid();

        public int tradeButtonWidth(TradeContext var1);

        public int tradeButtonHeight(TradeContext var1);

        default public boolean hasArrow(TradeContext context) {
            return true;
        }

        public Pair<Integer, Integer> arrowPosition(TradeContext var1);

        public Pair<Integer, Integer> alertPosition(TradeContext var1);

        public DisplayData inputDisplayArea(TradeContext var1);

        public DisplayData outputDisplayArea(TradeContext var1);

        public List<DisplayEntry> getInputDisplays(TradeContext var1);

        public List<DisplayEntry> getOutputDisplays(TradeContext var1);

        default public boolean hasAlert(TradeContext context) {
            List<AlertData> alerts = this.getAlertData(context);
            return alerts != null && alerts.size() > 0;
        }

        public List<AlertData> getAlertData(TradeContext var1);

        default public void renderAdditional(AbstractWidget button, PoseStack pose, int mouseX, int mouseY, TradeContext context) {
        }

        default public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
            return null;
        }

        public void onInputDisplayInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, ItemStack var5);

        public void onOutputDisplayInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, ItemStack var5);

        public void onInteraction(BasicTradeEditTab var1, @Nullable TraderStorageMenu.IClientMessage var2, int var3, int var4, int var5, ItemStack var6);
    }

    public static abstract class DisplayEntry {
        private static final DisplayEntry EMPTY = DisplayEntry.of((Component)new TextComponent(""), TextRenderUtil.TextFormatting.create());
        private final List<Component> tooltip;

        @Deprecated
        protected DisplayEntry() {
            this.tooltip = null;
        }

        protected DisplayEntry(List<Component> tooltip) {
            this.tooltip = tooltip;
        }

        protected final Font getFont() {
            Minecraft m = Minecraft.m_91087_();
            return m.f_91062_;
        }

        protected List<Component> getTooltip() {
            if (this.tooltip == null) {
                return new ArrayList<Component>();
            }
            return this.tooltip;
        }

        public abstract void render(GuiComponent var1, PoseStack var2, int var3, int var4, DisplayData var5);

        public abstract boolean isMouseOver(int var1, int var2, DisplayData var3, int var4, int var5);

        public static DisplayEntry of(ItemStack item, int count) {
            return new ItemEntry(item, count, null);
        }

        public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip) {
            return new ItemEntry(item, count, tooltip);
        }

        public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background) {
            return new EmptySlotEntry(background, null);
        }

        public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
            return new EmptySlotEntry(background, tooltip);
        }

        public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format) {
            return new TextEntry(text, format, null);
        }

        public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
            return new TextEntry(text, format, tooltip);
        }

        public static DisplayEntry of(CoinValue price) {
            return new PriceEntry(price, null, false);
        }

        public static DisplayEntry of(CoinValue price, List<Component> additionalTooltips) {
            return new PriceEntry(price, additionalTooltips, false);
        }

        public static DisplayEntry of(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
            return new PriceEntry(price, additionalTooltips, tooltipOverride);
        }

        private static class ItemEntry
        extends DisplayEntry {
            private final ItemStack item;

            private ItemEntry(ItemStack item, int count, List<Component> tooltip) {
                super(tooltip);
                this.item = item.m_41777_();
                this.item.m_41764_(count);
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            @Override
            public void render(GuiComponent gui, PoseStack pose, int x, int y, DisplayData area) {
                if (this.item.m_41619_()) {
                    return;
                }
                Font font = this.getFont();
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                ItemRenderUtil.drawItemStack(gui, font, this.item, left, top);
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
            }
        }

        private static class EmptySlotEntry
        extends DisplayEntry {
            private final Pair<ResourceLocation, ResourceLocation> background;

            private EmptySlotEntry(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
                super(tooltip);
                this.background = background;
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            @Override
            public void render(GuiComponent gui, PoseStack pose, int x, int y, DisplayData area) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                ItemRenderUtil.drawSlotBackground(pose, left, top, this.background);
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTopLeft(x + area.xOffset, area.width);
                int top = this.getTopLeft(y + area.yOffset, area.height);
                return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
            }
        }

        private static class TextEntry
        extends DisplayEntry {
            private final Component text;
            private final TextRenderUtil.TextFormatting format;

            private TextEntry(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
                super(tooltip);
                this.text = text;
                this.format = format;
            }

            protected int getTextLeft(int x, int availableWidth) {
                if (this.format.centering().isCenter()) {
                    return x + availableWidth / 2 - this.getTextWidth() / 2;
                }
                if (this.format.centering().isRight()) {
                    return x + availableWidth - this.getTextWidth();
                }
                return x;
            }

            protected int getTextTop(int y, int availableHeight) {
                if (this.format.centering().isMiddle()) {
                    int n = y + availableHeight / 2;
                    Objects.requireNonNull(this.getFont());
                    return n - 9 / 2;
                }
                if (this.format.centering().isBottom()) {
                    Objects.requireNonNull(this.getFont());
                    return y + availableHeight - 9;
                }
                return y;
            }

            protected int getTextWidth() {
                return this.getFont().m_92852_((FormattedText)this.text);
            }

            @Override
            public void render(GuiComponent gui, PoseStack pose, int x, int y, DisplayData area) {
                if (this.text.getString().isBlank()) {
                    return;
                }
                Font font = this.getFont();
                int left = this.getTextLeft(x + area.xOffset, area.width);
                int top = this.getTextTop(y + area.yOffset, area.height);
                font.m_92763_(pose, this.text, (float)left, (float)top, this.format.color());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = this.getTextLeft(x + area.xOffset, area.width);
                int top = this.getTextTop(y + area.yOffset, area.height);
                if (mouseX < left) return false;
                if (mouseX >= left + this.getTextWidth()) return false;
                if (mouseY < top) return false;
                Objects.requireNonNull(this.getFont());
                if (mouseY >= top + 9) return false;
                return true;
            }
        }

        private static class PriceEntry
        extends DisplayEntry {
            private final CoinValue price;

            public PriceEntry(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
                super(PriceEntry.getTooltip(price, additionalTooltips, tooltipOverride));
                this.price = price;
            }

            private int getTopLeft(int xOrY, int availableWidthOrHeight) {
                return xOrY + availableWidthOrHeight / 2 - 8;
            }

            private static List<Component> getTooltip(CoinValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                if (tooltipOverride && additionalTooltips != null) {
                    return additionalTooltips;
                }
                if (!price.isFree() && price.isValid()) {
                    tooltips.add((Component)new TextComponent(price.getString()));
                }
                if (additionalTooltips != null) {
                    tooltips.addAll(additionalTooltips);
                }
                return tooltips;
            }

            @Override
            public void render(GuiComponent gui, PoseStack pose, int x, int y, DisplayData area) {
                block3: {
                    List<CoinValue.CoinValuePair> entries;
                    block4: {
                        block2: {
                            if (!this.price.isFree()) break block2;
                            Font font = this.getFont();
                            int left = x + area.xOffset + area.width / 2 - font.m_92895_(this.price.getString()) / 2;
                            int n = y + area.yOffset + area.height / 2;
                            Objects.requireNonNull(font);
                            int top = n - 9 / 2;
                            font.m_92889_(pose, (Component)new TextComponent(this.price.getString()), (float)left, (float)top, 0xFFFFFF);
                            break block3;
                        }
                        entries = this.price.getEntries();
                        if (entries.size() * 16 > area.width) break block4;
                        List<DisplayData> entryPositions = area.divide(entries.size());
                        for (int i = 0; i < entryPositions.size() && i < entries.size(); ++i) {
                            DisplayData pos = entryPositions.get(i);
                            int left = this.getTopLeft(x + pos.xOffset, pos.width);
                            int top = this.getTopLeft(y + pos.yOffset, pos.height);
                            ItemStack stack = new ItemStack((ItemLike)entries.get((int)i).coin);
                            stack.m_41764_(entries.get((int)i).amount);
                            ItemRenderUtil.drawItemStack(gui, this.getFont(), stack, left, top);
                        }
                        break block3;
                    }
                    if (entries.size() <= 0) break block3;
                    int spacing = (area.width - 16) / entries.size();
                    int top = this.getTopLeft(y + area.yOffset, area.height);
                    int left = x + area.xOffset + area.width - 16;
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        ItemStack stack = new ItemStack((ItemLike)entries.get((int)i).coin);
                        stack.m_41764_(entries.get((int)i).amount);
                        ItemRenderUtil.drawItemStack(gui, this.getFont(), stack, left, top);
                        left -= spacing;
                    }
                }
            }

            @Override
            public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
                int left = x + area.xOffset;
                int top = y + area.yOffset;
                return mouseX >= left && mouseX < left + area.width && mouseY >= top && mouseY < top + area.height;
            }
        }
    }

    public static class DisplayData {
        public final int xOffset;
        public final int yOffset;
        public final int width;
        public final int height;

        public DisplayData(int xOffset, int yOffset, int width, int height) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.width = width;
            this.height = height;
        }

        public List<DisplayData> divide(int count) {
            if (count <= 1) {
                return Lists.newArrayList((Object[])new DisplayData[]{this});
            }
            int partialWidth = this.width / count;
            int x = this.xOffset;
            ArrayList<DisplayData> result = new ArrayList<DisplayData>();
            for (int i = 0; i < count; ++i) {
                result.add(new DisplayData(x, this.yOffset, partialWidth, this.height));
                x += partialWidth;
            }
            return result;
        }
    }
}

