/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class FreezerTraderBlockEntityRenderer
implements BlockEntityRenderer<FreezerTraderBlockEntity> {
    public static final Item doorItem = (Item)ModItems.FREEZER_DOOR.get();

    public FreezerTraderBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FreezerTraderBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(tileEntity, partialTicks, poseStack, bufferSource, lightLevel, id);
        poseStack.m_85836_();
        Vector3f corner = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        Block freezerBlock = tileEntity.m_58900_().m_60734_();
        Direction facing = Direction.SOUTH;
        if (freezerBlock instanceof IRotatableBlock) {
            IRotatableBlock block = (IRotatableBlock)freezerBlock;
            facing = block.getFacing(tileEntity.m_58900_());
            corner = IRotatableBlock.getOffsetVect(facing);
            right = IRotatableBlock.getRightVect(facing);
            forward = IRotatableBlock.getForwardVect(facing);
        }
        Vector3f hinge = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.96875f), MathUtil.VectorMult(forward, 0.21875f));
        Quaternion rotation = Vector3f.f_122225_.m_122240_((float)facing.m_122416_() * -90.0f + 90.0f * tileEntity.getDoorAngle(partialTicks));
        poseStack.m_85837_((double)hinge.m_122239_(), (double)hinge.m_122260_(), (double)hinge.m_122269_());
        poseStack.m_85845_(rotation);
        ItemStack stack = new ItemStack((ItemLike)doorItem);
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, poseStack, bufferSource, id);
        poseStack.m_85849_();
    }
}

