/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.atm.icons;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMConversionButton;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpriteIcon
extends ATMIconData {
    public static final ResourceLocation TYPE_NAME = new ResourceLocation("lightmanscurrency", "sprite");
    public static final ATMIconData.IconType TYPE = ATMIconData.IconType.create(TYPE_NAME, SpriteIcon::new);
    private final ResourceLocation texture;
    private final int u;
    private final int v;
    private final int width;
    private final int height;

    public SpriteIcon(JsonObject data) {
        super(data);
        this.texture = new ResourceLocation(data.get("texture").getAsString());
        this.u = data.get("u").getAsInt();
        this.v = data.get("v").getAsInt();
        this.width = data.get("width").getAsInt();
        this.height = data.get("height").getAsInt();
    }

    public SpriteIcon(int xPos, int yPos, ResourceLocation texture, int u, int v, int width, int height) {
        super(xPos, yPos);
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    @Override
    protected void saveAdditional(JsonObject data) {
        data.addProperty("texture", this.texture.toString());
        data.addProperty("u", (Number)this.u);
        data.addProperty("v", (Number)this.v);
        data.addProperty("width", (Number)this.width);
        data.addProperty("height", (Number)this.height);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ATMConversionButton button, PoseStack pose, boolean isHovered) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        button.m_93228_(pose, button.f_93620_ + this.xPos, button.f_93621_ + this.yPos, this.u, this.v, this.width, this.height);
    }
}

