/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.trader.IDumpable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class EjectionData
implements Container {
    boolean playerOwner = false;
    UUID ownerID = null;
    MutableComponent traderName = new TextComponent("");
    List<ItemStack> items = new ArrayList<ItemStack>();
    private boolean isClient = false;

    public MutableComponent getTraderName() {
        return this.traderName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    private EjectionData() {
    }

    private EjectionData(boolean isPlayer, UUID ownerID, MutableComponent traderName, List<ItemStack> items) {
        this.playerOwner = isPlayer;
        this.ownerID = ownerID;
        this.traderName = traderName;
        this.items = items;
    }

    public boolean canAccess(Player player) {
        Team team;
        if (TradingOffice.isAdminPlayer(player)) {
            return true;
        }
        if (this.ownerID == null) {
            return false;
        }
        if (this.playerOwner) {
            return player.m_142081_().equals(this.ownerID);
        }
        Team team2 = team = player.f_19853_.f_46443_ ? ClientTradingOffice.getTeam(this.ownerID) : TradingOffice.getTeam(this.ownerID);
        if (team != null) {
            return team.isMember(player);
        }
        return false;
    }

    public CompoundTag save(CompoundTag compound) {
        if (this.ownerID != null) {
            compound.m_128379_("PlayerOwned", this.playerOwner);
            compound.m_128362_("Owner", this.ownerID);
        }
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.traderName));
        ListTag itemList = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            itemList.add((Object)this.items.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Items", (Tag)itemList);
        return compound;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("PlayerOwned")) {
            this.playerOwner = compound.m_128471_("PlayerOwned");
        }
        if (compound.m_128441_("Owner")) {
            this.ownerID = compound.m_128342_("Owner");
        }
        if (compound.m_128441_("Name")) {
            this.traderName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        }
        if (compound.m_128441_("Items")) {
            ListTag itemList = compound.m_128437_("Items", 10);
            this.items = new ArrayList<ItemStack>();
            for (int i = 0; i < itemList.size(); ++i) {
                this.items.add(ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i)));
            }
        }
    }

    public static EjectionData create(BlockState state, IDumpable trader) {
        boolean playerOwner = true;
        UUID ownerID = null;
        Team team = trader.getTeam();
        if (team != null) {
            playerOwner = false;
            ownerID = team.getID();
        } else if (trader.getOwner() != null) {
            ownerID = trader.getOwner().id;
        }
        MutableComponent traderName = trader.getName();
        List<ItemStack> items = trader.dumpContents(state, true);
        return new EjectionData(playerOwner, ownerID, traderName, items);
    }

    public static EjectionData loadData(CompoundTag compound) {
        EjectionData data = new EjectionData();
        data.load(compound);
        return data;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack i : this.items) {
            if (i.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return this.items.get(slot).m_41620_(count);
    }

    public ItemStack m_8016_(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.items.get(slot);
        this.items.set(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack item) {
        if (slot >= this.items.size() || slot < 0) {
            return;
        }
        this.items.set(slot, item);
    }

    private void clearEmptySlots() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).m_41619_()) continue;
            this.items.remove(i);
            --i;
        }
    }

    public void m_6596_() {
        if (this.isClient) {
            return;
        }
        this.clearEmptySlots();
        if (this.m_7983_()) {
            TradingOffice.removeEjectionData(this);
        } else {
            TradingOffice.MarkEjectionDataDirty();
        }
    }

    public boolean m_6542_(Player player) {
        return this.canAccess(player);
    }
}

