/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.enchantments;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.enchantments.LCEnchantmentCategories;
import io.github.lightman314.lightmanscurrency.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CoinMagnetEnchantment
extends WalletEnchantment {
    public static final int MAX_LEVEL = 3;
    public static final int MAX_CALCULATION_LEVEL = 5;

    public CoinMagnetEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, LCEnchantmentCategories.WALLET_PICKUP_CATEGORY, slots);
    }

    public int m_6183_(int level) {
        return 5 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public static void runEntityTick(LivingEntity entity) {
        WalletCapability.getWalletHandler((Entity)entity).ifPresent(walletHandler -> {
            ItemStack wallet = walletHandler.getWallet();
            if (!(WalletItem.isWallet(wallet) && wallet.m_41720_() instanceof WalletItem && WalletItem.CanPickup((WalletItem)wallet.m_41720_()))) {
                return;
            }
            int enchantLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COIN_MAGNET.get()), (ItemStack)wallet);
            if (enchantLevel <= 0) {
                return;
            }
            float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
            Level level = entity.f_19853_;
            if (level == null) {
                return;
            }
            AABB searchBox = new AABB(entity.f_19854_ - (double)range, entity.f_19855_ - (double)range, entity.f_19856_ - (double)range, entity.f_19854_ + (double)range, entity.f_19855_ + (double)range, entity.f_19856_ + (double)range);
            boolean updateWallet = false;
            for (Entity e2 : level.m_6249_((Entity)entity, searchBox, e -> e instanceof ItemEntity && MoneyUtil.isCoin(((ItemEntity)e).m_32055_(), false))) {
                ItemEntity ie = (ItemEntity)e2;
                ItemStack coinStack = ie.m_32055_();
                ItemStack leftovers = WalletItem.PickupCoin(wallet, coinStack);
                if (leftovers.m_41613_() == coinStack.m_41613_()) continue;
                updateWallet = true;
                if (leftovers.m_41619_()) {
                    ie.m_146870_();
                } else {
                    ie.m_32045_(leftovers);
                }
                level.m_6269_(null, (Entity)entity, CurrencySoundEvents.COINS_CLINKING, SoundSource.PLAYERS, 0.4f, 1.0f);
            }
            if (updateWallet) {
                walletHandler.setWallet(wallet);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.f_36096_ instanceof WalletMenuBase) {
                        ((WalletMenuBase)player.f_36096_).reloadWalletContents();
                    }
                }
            }
        });
    }

    public static float getCollectionRange(int enchantLevel) {
        if (--enchantLevel < 0) {
            return 0.0f;
        }
        return (Integer)Config.SERVER.coinMagnetRangeBase.get() + (Integer)Config.SERVER.coinMagnetRangeLevel.get() * Math.min(enchantLevel, 4);
    }

    public static Component getCollectionRangeDisplay(int enchantLevel) {
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        String display = range % 1.0f > 0.0f ? String.valueOf(range) : String.valueOf(Math.round(range));
        return new TextComponent(display).m_130940_(ChatFormatting.GREEN);
    }

    @Override
    public void addWalletTooltips(List<Component> tooltips, int enchantLevel, ItemStack wallet) {
        if (wallet.m_41720_() instanceof WalletItem && enchantLevel > 0 && WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            tooltips.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.wallet.pickup.magnet", new Object[]{CoinMagnetEnchantment.getCollectionRangeDisplay(enchantLevel)}).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

