/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.SpawnTrackerCapability;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class LootManager {
    public static final float LOOTING_MODIFIER = 0.01f;
    private static final String ENTITY = "minecraft:";
    private static final String CHEST = "minecraft:chests/";
    public static final List<String> ENTITY_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:slime", (Object)"minecraft:silverfish");
    public static final List<String> ENTITY_IRON_DROPLIST = ImmutableList.of((Object)"minecraft:zombie", (Object)"minecraft:skeleton", (Object)"minecraft:creeper", (Object)"minecraft:spider", (Object)"minecraft:cave_spider", (Object)"minecraft:husk", (Object)"minecraft:stray", (Object)"minecraft:magma_cube", (Object)"minecraft:zombie_villager", (Object)"minecraft:drowned");
    public static final List<String> ENTITY_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:guardian", (Object)"minecraft:elder_guardian", (Object)"minecraft:phantom", (Object)"minecraft:blaze", (Object)"minecraft:ghast", (Object)"minecraft:witch", (Object)"minecraft:hoglin", (Object)"minecraft:piglin_brute", (Object)"minecraft:piglin", (Object)"minecraft:zombified_piglin");
    public static final List<String> ENTITY_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:enderman", (Object)"minecraft:evoker", (Object)"minecraft:vindicator", (Object)"minecraft:pillager", (Object)"minecraft:ravager", (Object)"minecraft:shulker");
    public static final List<String> ENTITY_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:wither_skeleton");
    public static final List<String> ENTITY_NETHERITE_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_COPPER_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_GOLD_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:warden");
    public static final List<String> ENTITY_BOSS_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:ender_dragon");
    public static final List<String> ENTITY_BOSS_NETHERITE_DROPLIST = ImmutableList.of((Object)"minecraft:wither");
    public static final List<String> CHEST_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:chests/underwater_ruin_small", (Object)"minecraft:chests/underwater_ruin_big");
    public static final List<String> CHEST_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> CHEST_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/jungle_temple", (Object)"minecraft:chests/nether_bridge", (Object)"minecraft:chests/simple_dungeon", (Object)"minecraft:chests/ruined_portal");
    public static final List<String> CHEST_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/stronghold_crossing", (Object)"minecraft:chests/stronghold_corridor", (Object)"minecraft:chests/stronghold_library", (Object)"minecraft:chests/ancient_city");
    public static final List<String> CHEST_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:chests/buried_treasure", (Object)"minecraft:chests/bastion_hoglin_stable", (Object)"minecraft:chests/bastion_bridge", (Object)"minecraft:chests/bastion_other", (Object)"minecraft:chests/bastion_treasure", (Object)"minecraft:chests/end_city_treasure");
    public static final List<String> CHEST_NETHERITE_DROPLIST = ImmutableList.of();
    private static final Map<String, PoolLevel> EXTERNAL_ENTITY_ENTRIES = new HashMap<String, PoolLevel>();
    private static final Map<String, PoolLevel> EXTERNAL_CHEST_ENTRIES = new HashMap<String, PoolLevel>();
    private static boolean lootTablesBuilt = false;
    private static LootPool.Builder ENTITY_LOOT_COPPER = null;
    private static LootPool.Builder ENTITY_LOOT_IRON = null;
    private static LootPool.Builder ENTITY_LOOT_GOLD = null;
    private static LootPool.Builder ENTITY_LOOT_EMERALD = null;
    private static LootPool.Builder ENTITY_LOOT_DIAMOND = null;
    private static LootPool.Builder ENTITY_LOOT_NETHERITE = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_COPPER = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_IRON = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_GOLD = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_EMERALD = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_DIAMOND = null;
    private static List<LootPool.Builder> ENTITY_LOOT_BOSS_NETHERITE = null;
    private static LootPool.Builder CHEST_LOOT_COPPER = null;
    private static LootPool.Builder CHEST_LOOT_IRON = null;
    private static LootPool.Builder CHEST_LOOT_GOLD = null;
    private static LootPool.Builder CHEST_LOOT_EMERALD = null;
    private static LootPool.Builder CHEST_LOOT_DIAMOND = null;
    private static LootPool.Builder CHEST_LOOT_NETHERITE = null;

    public static boolean isValidSpawnReason(String reasonString) {
        for (MobSpawnType reason : MobSpawnType.values()) {
            if (reason.toString() != reasonString) continue;
            return true;
        }
        return false;
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString) {
        return LootManager.deserializeSpawnReason(reasonString, MobSpawnType.NATURAL);
    }

    public static MobSpawnType deserializeSpawnReason(String reasonString, MobSpawnType defaultReason) {
        for (MobSpawnType reason : MobSpawnType.values()) {
            if (!reason.toString().contentEquals(reasonString)) continue;
            return reason;
        }
        LightmansCurrency.LogWarning("Reason string \"" + reasonString + "\" could not be properly deserialized. Returning the default spawn reason.");
        return defaultReason;
    }

    public static boolean containsReason(List<? extends String> reasonList, MobSpawnType reason) {
        for (int i = 0; i < reasonList.size(); ++i) {
            if (!reason.toString().contentEquals(reasonList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getSpawnReasonList() {
        StringBuffer output = new StringBuffer();
        for (MobSpawnType reason : MobSpawnType.values()) {
            if (output.length() > 0) {
                output.append(", ");
            }
            output.append(reason);
        }
        return output.toString();
    }

    private static void generateLootTables() {
        if (lootTablesBuilt) {
            return;
        }
        ENTITY_LOOT_COPPER = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 1.0f, 10.0f, 0.75f, "lightmanscurrency:entityloot_copper", true);
        ENTITY_LOOT_IRON = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 1.0f, 5.0f, 0.5f, "lightmanscurrency:entityloot_iron", true);
        ENTITY_LOOT_GOLD = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_GOLD.get(), 1.0f, 5.0f, 0.25f, "lightmanscurrency:entityloot_gold", true);
        ENTITY_LOOT_EMERALD = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_EMERALD.get(), 1.0f, 3.0f, 0.1f, "lightmanscurrency:entityloot_emerald", true);
        ENTITY_LOOT_DIAMOND = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_DIAMOND.get(), 1.0f, 3.0f, 0.05f, "lightmanscurrency:entityloot_diamond", true);
        ENTITY_LOOT_NETHERITE = LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_NETHERITE.get(), 1.0f, 3.0f, 0.025f, "lightmanscurrency:entityloot_netherite", true);
        ENTITY_LOOT_BOSS_COPPER = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false));
        ENTITY_LOOT_BOSS_IRON = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false));
        ENTITY_LOOT_BOSS_GOLD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_GOLD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false));
        ENTITY_LOOT_BOSS_EMERALD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_GOLD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_EMERALD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false));
        ENTITY_LOOT_BOSS_DIAMOND = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_GOLD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_EMERALD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_DIAMOND.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false));
        ENTITY_LOOT_BOSS_NETHERITE = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_COPPER.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_IRON.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_GOLD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_EMERALD.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_DIAMOND.get(), 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false), (Object)LootManager.GenerateEntityCoinPool((Item)ModItems.COIN_NETHERITE.get(), 1.0f, 5.0f, 1.0f, "lightmanscurrency:coinloot_boss_netherite", false));
        CHEST_LOOT_COPPER = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER}, 1.0f, 5.0f, "lightmanscurrency:chestloot_copper");
        CHEST_LOOT_IRON = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON}, 1.0f, 5.0f, "lightmanscurrency:chestloot_iron");
        CHEST_LOOT_GOLD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD}, 2.0f, 6.0f, "lightmanscurrency:chestloot_gold");
        CHEST_LOOT_EMERALD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD}, 3.0f, 6.0f, "lightmanscurrency:chestloot_emerald");
        CHEST_LOOT_DIAMOND = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND}, 3.0f, 6.0f, "lightmanscurrency:chestloot_diamond");
        CHEST_LOOT_NETHERITE = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND, ChestLootEntryData.NETHERITE}, 3.0f, 6.0f, "lightmanscurrency:chestloot_netherite");
        lootTablesBuilt = true;
    }

    private static String getValueList(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
        StringBuffer buffer = new StringBuffer();
        List list = (List)config.get();
        for (String value : list) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"").append(value).append("\"");
        }
        return buffer.toString();
    }

    public static void debugLootConfigs() {
        LightmansCurrency.LogDebug("Lightman's Currency common configs have been loaded. Coin loot values are as follows.");
        LightmansCurrency.LogDebug("Chest Copper: " + LootManager.getValueList(Config.COMMON.copperChestDrops));
        LightmansCurrency.LogDebug("Chest Iron: " + LootManager.getValueList(Config.COMMON.ironChestDrops));
        LightmansCurrency.LogDebug("Chest Gold: " + LootManager.getValueList(Config.COMMON.goldChestDrops));
        LightmansCurrency.LogDebug("Chest Emerald: " + LootManager.getValueList(Config.COMMON.emeraldChestDrops));
        LightmansCurrency.LogDebug("Chest Diamond: " + LootManager.getValueList(Config.COMMON.diamondChestDrops));
        LightmansCurrency.LogDebug("Chest Netherite: " + LootManager.getValueList(Config.COMMON.netheriteChestDrops));
        LightmansCurrency.LogDebug("Entity Copper (Normal): " + LootManager.getValueList(Config.COMMON.copperEntityDrops));
        LightmansCurrency.LogDebug("Entity Iron (Normal): " + LootManager.getValueList(Config.COMMON.ironEntityDrops));
        LightmansCurrency.LogDebug("Entity Gold (Normal): " + LootManager.getValueList(Config.COMMON.goldEntityDrops));
        LightmansCurrency.LogDebug("Entity Emerald (Normal): " + LootManager.getValueList(Config.COMMON.emeraldEntityDrops));
        LightmansCurrency.LogDebug("Entity Diamond (Normal): " + LootManager.getValueList(Config.COMMON.diamondEntityDrops));
        LightmansCurrency.LogDebug("Entity Netherite (Normal): " + LootManager.getValueList(Config.COMMON.netheriteEntityDrops));
        LightmansCurrency.LogDebug("Entity Copper (Boss): " + LootManager.getValueList(Config.COMMON.bossCopperEntityDrops));
        LightmansCurrency.LogDebug("Entity Iron (Boss): " + LootManager.getValueList(Config.COMMON.bossIronEntityDrops));
        LightmansCurrency.LogDebug("Entity Gold (Boss): " + LootManager.getValueList(Config.COMMON.bossGoldEntityDrops));
        LightmansCurrency.LogDebug("Entity Emerald (Boss): " + LootManager.getValueList(Config.COMMON.bossEmeraldEntityDrops));
        LightmansCurrency.LogDebug("Entity Diamond (Boss): " + LootManager.getValueList(Config.COMMON.bossDiamondEntityDrops));
        LightmansCurrency.LogDebug("Entity Netherite (Boss): " + LootManager.getValueList(Config.COMMON.bossNetheriteEntityDrops));
    }

    @SubscribeEvent
    public static void onEntitySpawned(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player) {
            return;
        }
        SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).ifPresent(spawnerTracker -> spawnerTracker.setSpawnReason(event.getSpawnReason()));
        if (!SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).isPresent()) {
            LightmansCurrency.LogWarning(event.getEntityLiving().m_7755_().getString() + " does not have a ISpawnerTracker attached. Unable to flag it's SpawnReason.");
        }
    }

    @SubscribeEvent
    public static void attachSpawnTrackerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && !(event.getObject() instanceof Player)) {
            event.addCapability(CurrencyCapabilities.ID_SPAWN_TRACKER, SpawnTrackerCapability.createProvider((LivingEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().f_19853_.f_46443_) {
            return;
        }
        if (!((Boolean)Config.COMMON.enableSpawnerEntityDrops.get()).booleanValue()) {
            AtomicReference spawnReason = new AtomicReference();
            SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).ifPresent(spawnerTracker -> spawnReason.set(spawnerTracker.spawnReason()));
            if (spawnReason.get() == MobSpawnType.SPAWNER) {
                LightmansCurrency.LogDebug(event.getEntityLiving().m_7755_().getString() + " did not drop coins, as it was spawned by a spawner.");
                return;
            }
        }
        String name = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntityLiving().m_6095_()).toString();
        if (event.getSource().m_7640_() instanceof Player || event.getSource().m_7639_() instanceof Player) {
            Player player;
            Player player2 = player = event.getSource().m_7640_() instanceof Player ? (Player)event.getSource().m_7640_() : (Player)event.getSource().m_7639_();
            if (((List)Config.COMMON.copperEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.COPPER);
            } else if (((List)Config.COMMON.ironEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.IRON);
            } else if (((List)Config.COMMON.goldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.GOLD);
            } else if (((List)Config.COMMON.emeraldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.EMERALD);
            } else if (((List)Config.COMMON.diamondEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.DIAMOND);
            } else if (((List)Config.COMMON.netheriteEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.NETHERITE);
            } else if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_COPPER);
            } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_IRON);
            } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_GOLD);
            } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_EMERALD);
            } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_DIAMOND);
            } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_NETHERITE);
            } else {
                EXTERNAL_ENTITY_ENTRIES.forEach((entity, level) -> {
                    if (entity.equals(name)) {
                        LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, level);
                        return;
                    }
                });
            }
            return;
        }
        if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_COPPER);
        } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_IRON);
        } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_GOLD);
        } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_EMERALD);
        } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_DIAMOND);
        } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, PoolLevel.BOSS_NETHERITE);
        } else {
            EXTERNAL_ENTITY_ENTRIES.forEach((entity, level) -> {
                if (entity.equals(name) && !level.requiresPlayerKill) {
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), null, level);
                }
            });
        }
    }

    public static void validateEntityDropList() {
        LootManager.validateDropList(Config.COMMON.copperEntityDrops);
        LootManager.validateDropList(Config.COMMON.ironEntityDrops);
        LootManager.validateDropList(Config.COMMON.goldEntityDrops);
        LootManager.validateDropList(Config.COMMON.emeraldEntityDrops);
        LootManager.validateDropList(Config.COMMON.diamondEntityDrops);
        LootManager.validateDropList(Config.COMMON.netheriteEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossCopperEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossIronEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossGoldEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossEmeraldEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossDiamondEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossNetheriteEntityDrops);
    }

    private static void validateDropList(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
        List configList = (List)config.get();
        ArrayList list = Lists.newArrayList();
        configList.forEach(value -> list.add(value));
        boolean modified = false;
        for (int i = 0; i < list.size(); ++i) {
            String value2 = (String)list.get(i);
            if (value2.contains("entities/")) {
                value2 = value2.replace("entities/", "");
                list.set(i, value2);
                modified = true;
            }
            if (!value2.contains("entities\\")) continue;
            value2 = value2.replace("entities\\", "");
            list.set(i, value2);
            modified = true;
        }
        if (modified) {
            config.set((Object)list);
        }
    }

    private static void DropEntityLoot(Entity entity, Player player, PoolLevel coinPool) {
        if (!((Boolean)Config.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        LootManager.generateLootTables();
        LootTable table = LootTable.m_79147_().m_79167_();
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)entity.f_19853_);
        if (player != null) {
            contextBuilder.m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player);
        }
        LootContext context = contextBuilder.m_78975_(new LootContextParamSet.Builder().m_81408_(LootContextParams.f_81456_).m_81408_(LootContextParams.f_81458_).m_81405_());
        try {
            if (coinPool == PoolLevel.BOSS_COPPER) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_COPPER) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            if (coinPool == PoolLevel.BOSS_IRON) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_IRON) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            if (coinPool == PoolLevel.BOSS_GOLD) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_GOLD) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            if (coinPool == PoolLevel.BOSS_EMERALD) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_EMERALD) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            if (coinPool == PoolLevel.BOSS_DIAMOND) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_DIAMOND) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            if (coinPool == PoolLevel.BOSS_NETHERITE) {
                for (LootPool.Builder builder : ENTITY_LOOT_BOSS_NETHERITE) {
                    table.addPool(builder.m_79082_());
                }
                LootManager.SpawnLootDrops(entity, table.m_79129_(context));
                return;
            }
            table.addPool(ENTITY_LOOT_COPPER.m_79082_());
            if (coinPool != PoolLevel.COPPER) {
                table.addPool(ENTITY_LOOT_IRON.m_79082_());
                if (coinPool != PoolLevel.IRON) {
                    table.addPool(ENTITY_LOOT_GOLD.m_79082_());
                    if (coinPool != PoolLevel.GOLD) {
                        table.addPool(ENTITY_LOOT_EMERALD.m_79082_());
                        if (coinPool != PoolLevel.EMERALD) {
                            table.addPool(ENTITY_LOOT_DIAMOND.m_79082_());
                            if (coinPool != PoolLevel.DIAMOND) {
                                table.addPool(ENTITY_LOOT_NETHERITE.m_79082_());
                            }
                        }
                    }
                }
            }
            LootManager.SpawnLootDrops(entity, table.m_79129_(context));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error spawning coin drops!", e);
        }
    }

    public static List<ItemStack> GetRandomChestLoot(PoolLevel coinPool, LootContext context) {
        LootManager.generateLootTables();
        try {
            if (coinPool == PoolLevel.COPPER) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_COPPER.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.IRON) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_IRON.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.GOLD) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_GOLD.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.EMERALD) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_EMERALD.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.DIAMOND) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_DIAMOND.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.NETHERITE) {
                LootTable table = LootTable.m_79147_().m_79167_();
                table.addPool(CHEST_LOOT_NETHERITE.m_79082_());
                return LootManager.safelyGetResults(table, context);
            }
            LightmansCurrency.LogError("Attempting to get random chest loot from an invalid chest pool level of '" + (coinPool == null ? "NULL" : coinPool.toString()) + "'");
            return new ArrayList<ItemStack>();
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error spawning chest coin drops!", e);
            return new ArrayList<ItemStack>();
        }
    }

    private static List<ItemStack> safelyGetResults(LootTable table, LootContext context) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        table.m_79148_(context, results::add);
        return results;
    }

    public static PoolLevel GetChestPoolLevel(String lootTable) {
        if (((List)Config.COMMON.copperChestDrops.get()).contains(lootTable)) {
            return PoolLevel.COPPER;
        }
        if (((List)Config.COMMON.ironChestDrops.get()).contains(lootTable)) {
            return PoolLevel.IRON;
        }
        if (((List)Config.COMMON.goldChestDrops.get()).contains(lootTable)) {
            return PoolLevel.GOLD;
        }
        if (((List)Config.COMMON.emeraldChestDrops.get()).contains(lootTable)) {
            return PoolLevel.EMERALD;
        }
        if (((List)Config.COMMON.diamondChestDrops.get()).contains(lootTable)) {
            return PoolLevel.DIAMOND;
        }
        if (((List)Config.COMMON.netheriteChestDrops.get()).contains(lootTable)) {
            return PoolLevel.NETHERITE;
        }
        for (String chest : EXTERNAL_CHEST_ENTRIES.keySet()) {
            if (!chest.equals(lootTable)) continue;
            return EXTERNAL_CHEST_ENTRIES.get(chest);
        }
        return null;
    }

    private static void SpawnLootDrops(Entity entity, List<ItemStack> lootDrops) {
        InventoryUtil.dumpContents(entity.f_19853_, entity.m_142538_(), lootDrops);
    }

    public static void AddEntityCoinPoolToTable(String resource, PoolLevel coinPool) {
        EXTERNAL_ENTITY_ENTRIES.put(resource, coinPool);
    }

    public static void AddChestCoinPoolToTable(String resource, PoolLevel coinPool) {
        if (coinPool.level > PoolLevel.NETHERITE.level) {
            LightmansCurrency.LogError("Attempted to add a chest to the coin pool at level " + coinPool.name() + ", but that level is not valid for chests.");
            return;
        }
        EXTERNAL_CHEST_ENTRIES.put(resource, coinPool);
    }

    private static LootPool.Builder GenerateEntityCoinPool(Item item, float min, float max, float chance, String name, boolean requirePlayerKill) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).name(name);
        if (requirePlayerKill) {
            lootPoolBuilder.m_6509_(LootItemKilledByPlayerCondition.m_81901_());
        }
        if (chance < 1.0f) {
            lootPoolBuilder.m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }

    private static LootPool.Builder GenerateChestCoinPool(ChestLootEntryData[] lootEntries, float minRolls, float maxRolls, String name) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls)).name(name);
        for (ChestLootEntryData entry : lootEntries) {
            lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)entry.item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)entry.minCount, (float)entry.maxCount))).m_79707_(entry.weight));
        }
        return lootPoolBuilder;
    }

    private static class ChestLootEntryData {
        public final Item item;
        public final float minCount;
        public final float maxCount;
        public final int weight;
        public static ChestLootEntryData COPPER = new ChestLootEntryData((Item)ModItems.COIN_COPPER.get(), 1.0f, 10.0f, 1);
        public static ChestLootEntryData IRON = new ChestLootEntryData((Item)ModItems.COIN_IRON.get(), 1.0f, 10.0f, 2);
        public static ChestLootEntryData GOLD = new ChestLootEntryData((Item)ModItems.COIN_GOLD.get(), 1.0f, 10.0f, 3);
        public static ChestLootEntryData EMERALD = new ChestLootEntryData((Item)ModItems.COIN_EMERALD.get(), 1.0f, 10.0f, 4);
        public static ChestLootEntryData DIAMOND = new ChestLootEntryData((Item)ModItems.COIN_DIAMOND.get(), 1.0f, 8.0f, 5);
        public static ChestLootEntryData NETHERITE = new ChestLootEntryData((Item)ModItems.COIN_NETHERITE.get(), 1.0f, 3.0f, 6);

        public ChestLootEntryData(Item item, float minCount, float maxCount, int weight) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.weight = weight;
        }
    }

    public static enum PoolLevel {
        COPPER(0, true),
        IRON(1, true),
        GOLD(2, true),
        EMERALD(3, true),
        DIAMOND(4, true),
        NETHERITE(5, true),
        BOSS_COPPER(6, false),
        BOSS_IRON(7, false),
        BOSS_GOLD(8, false),
        BOSS_EMERALD(9, false),
        BOSS_DIAMOND(10, false),
        BOSS_NETHERITE(11, false);

        public final int level;
        private final boolean requiresPlayerKill;

        public final boolean requiresPlayerKill() {
            return this.requiresPlayerKill;
        }

        private PoolLevel(int level, boolean requiresPlayerKill) {
            this.level = level;
            this.requiresPlayerKill = requiresPlayerKill;
        }
    }
}

