/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.menus.containers.SuppliedContainer;
import io.github.lightman314.lightmanscurrency.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.SPacketChangeSelectedData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TraderRecoveryMenu
extends AbstractContainerMenu {
    public static final MenuProvider PROVIDER = new Provider();
    private final Player player;
    private int selectedIndex = 0;
    private final SuppliedContainer ejectionContainer;
    private final Container dummyContainer = new SimpleContainer(54);

    public TraderRecoveryMenu(int menuID, Inventory inventory) {
        this((MenuType)ModMenus.TRADER_RECOVERY.get(), menuID, inventory);
    }

    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    private final List<EjectionData> getEjectionData() {
        return this.isClient() ? ClientTradingOffice.getEjectionData() : TradingOffice.getEjectionData();
    }

    public List<EjectionData> getValidEjectionData() {
        return this.getEjectionData().stream().filter(e -> e.canAccess(this.player)).collect(Collectors.toList());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public EjectionData getSelectedData() {
        List<EjectionData> data = this.getValidEjectionData();
        if (data.size() > 0 && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex);
        }
        return null;
    }

    private Container getSelectedContainer() {
        List<EjectionData> data = this.getValidEjectionData();
        this.changeSelection(this.selectedIndex, data.size());
        if (data.size() > 0 && this.selectedIndex >= 0 && this.selectedIndex < data.size()) {
            return data.get(this.selectedIndex);
        }
        return this.dummyContainer;
    }

    protected TraderRecoveryMenu(MenuType<?> type, int menuID, Inventory inventory) {
        super(type, menuID);
        int x;
        int y;
        this.player = inventory.f_35978_;
        this.ejectionContainer = new SuppliedContainer(this::getSelectedContainer);
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new OutputSlot(this.ejectionContainer, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)inventory, x2, 8 + x2 * 18, 198));
        }
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex < 54 ? !this.m_38903_(itemstack1, 54, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.getValidEjectionData().size() > 0;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.dummyContainer);
    }

    public void changeSelection(int newSelection) {
        this.changeSelection(newSelection, this.getValidEjectionData().size());
    }

    private void changeSelection(int newSelection, int dataSize) {
        int oldSelection = this.selectedIndex;
        this.selectedIndex = MathUtil.clamp(newSelection, 0, dataSize - 1);
        if (this.selectedIndex != oldSelection && !this.isClient()) {
            LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(this.player), (Object)new SPacketChangeSelectedData(this.selectedIndex));
        }
    }

    private static class Provider
    implements MenuProvider {
        private Provider() {
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new TraderRecoveryMenu(id, inventory);
        }

        public Component m_5446_() {
            return new TextComponent("");
        }
    }
}

