/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.slots;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.trader.common.InteractionSlotData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InteractionSlot
extends Slot {
    public final List<InteractionSlotData> slotData;

    public InteractionSlot(List<InteractionSlotData> slotData, int x, int y) {
        super((Container)new SimpleContainer(1), 0, x, y);
        this.slotData = slotData;
    }

    public boolean isType(String type) {
        for (InteractionSlotData slot : this.slotData) {
            if (!slot.type.contentEquals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6659_() {
        return this.slotData.size() > 0;
    }

    public int m_6641_() {
        return 1;
    }

    public boolean m_5857_(ItemStack stack) {
        return InteractionSlotData.allowItemInSlot(this.slotData, stack);
    }

    public List<Pair<ResourceLocation, ResourceLocation>> getPossibleNoItemIcons() {
        ArrayList<Pair<ResourceLocation, ResourceLocation>> possibleBGs = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
        for (InteractionSlotData slot : this.slotData) {
            Pair<ResourceLocation, ResourceLocation> bg = slot.emptySlotBG();
            if (bg == null) continue;
            possibleBGs.add(bg);
        }
        return possibleBGs;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        Minecraft mc = Minecraft.m_91087_();
        int timer = (int)(mc.f_91073_.m_46467_() / 20L);
        List<Pair<ResourceLocation, ResourceLocation>> bgs = this.getPossibleNoItemIcons();
        return bgs.get(timer % bgs.size());
    }
}

