/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AuctionStorageTab
extends TraderStorageTab {
    public AuctionStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new AuctionStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.getTrader() instanceof AuctionHouseTrader;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld) {
        ITrader t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            if (storageSlot >= 0 && storageSlot < storage.getStoredItems().size()) {
                ItemStack storedItem = storage.getStoredItems().get(storageSlot);
                if (storedItem.m_41619_()) {
                    storage.getStoredItems().remove(storageSlot);
                    trader.markStorageDirty();
                } else {
                    int transferCount;
                    ItemStack heldItem = this.menu.m_142621_();
                    if (isShiftHeld) {
                        this.menu.player.m_150109_().m_36054_(storedItem);
                        if (storedItem.m_41619_()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    } else if (heldItem.m_41619_()) {
                        this.menu.m_142503_(storedItem);
                        storage.getStoredItems().remove(storageSlot);
                        trader.markStorageDirty();
                    } else if (InventoryUtil.ItemMatches(storedItem, heldItem) && (transferCount = Math.min(heldItem.m_41741_() - heldItem.m_41613_(), storedItem.m_41613_())) > 0) {
                        heldItem.m_41769_(transferCount);
                        this.menu.m_142503_(heldItem);
                        storedItem.m_41774_(transferCount);
                        if (storedItem.m_41619_()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    }
                }
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("ClickedSlot", storageSlot);
                message.m_128379_("HeldShift", isShiftHeld);
                this.menu.sendMessage(message);
            }
        }
    }

    public void quickTransfer() {
        ITrader t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            storage.collectItems(this.menu.player);
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("QuickTransfer", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void collectCoins() {
        ITrader t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            storage.collectedMoney(this.menu.player);
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("CollectMoney", true);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("ClickedSlot", 3)) {
            int storageSlot = message.m_128451_("ClickedSlot");
            boolean isShiftHeld = message.m_128471_("HeldShift");
            this.clickedOnSlot(storageSlot, isShiftHeld);
        }
        if (message.m_128441_("QuickTransfer")) {
            this.quickTransfer();
        }
        if (message.m_128441_("CollectMoney")) {
            this.collectCoins();
        }
    }
}

