/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.traderstorage.item;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item.ItemTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public ItemTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new ItemTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public ItemTradeData getTrade() {
        if (this.menu.getTrader() instanceof IItemTrader) {
            IItemTrader trader = (IItemTrader)this.menu.getTrader();
            if (this.tradeIndex >= trader.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return (ItemTradeData)((IItemTrader)this.menu.getTrader()).getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setType(ItemTradeData.ItemTradeType type) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTradeType(type);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("NewType", type.index);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setCustomName(int selectedSlot, String customName) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCustomName(selectedSlot, customName);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("Slot", selectedSlot);
                message.m_128359_("CustomName", customName);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setPrice(CoinValue price) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                price.writeToNBT(message, "NewPrice");
                this.menu.sendMessage(message);
            }
        }
    }

    public void setSelectedItem(int selectedSlot, ItemStack stack) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setItem(stack, selectedSlot);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("Slot", selectedSlot);
                message.m_128365_("NewItem", (Tag)stack.m_41739_(new CompoundTag()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void defaultInteraction(int slotIndex, ItemStack heldStack, int mouseButton) {
        ItemTradeData trade = this.getTrade();
        if (trade != null) {
            trade.onSlotInteraction(this, slotIndex, heldStack, mouseButton);
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("Interaction", slotIndex);
                message.m_128405_("Button", mouseButton);
                message.m_128365_("Item", (Tag)heldStack.m_41739_(new CompoundTag()));
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            this.tradeIndex = message.m_128451_("TradeIndex");
        } else if (message.m_128441_("Slot")) {
            int slot = message.m_128451_("Slot");
            if (message.m_128441_("CustomName")) {
                this.setCustomName(slot, message.m_128461_("CustomName"));
            } else if (message.m_128441_("NewItem")) {
                this.setSelectedItem(slot, ItemStack.m_41712_((CompoundTag)message.m_128469_("NewItem")));
            }
        } else if (message.m_128441_("NewPrice")) {
            CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
            price.readFromNBT(message, "NewPrice");
            this.setPrice(price);
        } else if (message.m_128441_("NewType")) {
            this.setType(ItemTradeData.ItemTradeType.fromIndex(message.m_128451_("NewType")));
        } else if (message.m_128441_("Interaction")) {
            int index = message.m_128451_("Interaction");
            int button = message.m_128451_("Button");
            this.defaultInteraction(index, ItemStack.m_41712_((CompoundTag)message.m_128469_("Item")), button);
        }
    }
}

