/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.auction.AuctionBidTab;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageStartBid {
    final UUID auctionHouseID;
    final int tradeIndex;

    public MessageStartBid(UUID auctionHouseID, int tradeIndex) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
    }

    public static void encode(MessageStartBid message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.auctionHouseID);
        buffer.writeInt(message.tradeIndex);
    }

    public static MessageStartBid decode(FriendlyByteBuf buffer) {
        return new MessageStartBid(buffer.m_130259_(), buffer.readInt());
    }

    public static void handle(MessageStartBid message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && mc.f_91080_ instanceof TraderScreen) {
                TraderScreen screen = (TraderScreen)mc.f_91080_;
                screen.setTab(new AuctionBidTab(screen, message.auctionHouseID, message.tradeIndex));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

