/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddPersistentAuction {
    private static final String GENERATE_ID_FORMAT = "auction_";
    final CompoundTag auctionData;
    final String id;

    public MessageAddPersistentAuction(CompoundTag auctionData, String id) {
        this.auctionData = auctionData;
        this.id = id;
    }

    private JsonObject getAuctionJson(String id) {
        AuctionTradeData auction = new AuctionTradeData(this.auctionData);
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json = auction.saveToJson(json);
        return json;
    }

    public static void encode(MessageAddPersistentAuction message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.auctionData);
        buffer.m_130070_(message.id);
    }

    public static MessageAddPersistentAuction decode(FriendlyByteBuf buffer) {
        return new MessageAddPersistentAuction(buffer.m_130261_(), buffer.m_130277_());
    }

    public static void handle(MessageAddPersistentAuction message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (TradingOffice.isAdminPlayer((Player)player)) {
                int i;
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    JsonObject auctionJson = message.getAuctionJson(message.id);
                    JsonArray persistentAuctions = TradingOffice.getPersistentTraderJson("Auctions");
                    for (int i2 = 0; i2 < persistentAuctions.size(); ++i2) {
                        JsonObject auctionData = persistentAuctions.get(i2).getAsJsonObject();
                        if (!auctionData.has("id") || !auctionData.get("id").getAsString().equals(message.id)) continue;
                        persistentAuctions.set(i2, (JsonElement)auctionJson);
                        TradingOffice.setPersistentTraderSection("Auctions", persistentAuctions);
                        player.m_6352_((Component)new TranslatableComponent("lightmanscurrency.message.persistent.auction.overwrite", new Object[]{message.id}), new UUID(0L, 0L));
                        return;
                    }
                    persistentAuctions.add((JsonElement)auctionJson);
                    TradingOffice.setPersistentTraderSection("Auctions", persistentAuctions);
                    player.m_6352_((Component)new TranslatableComponent("lightmanscurrency.message.persistent.auction.add", new Object[]{message.id}), new UUID(0L, 0L));
                    return;
                }
                ArrayList<String> knownIDs = new ArrayList<String>();
                JsonArray persistentAuctions = TradingOffice.getPersistentTraderJson("Auctions");
                for (i = 0; i < persistentAuctions.size(); ++i) {
                    JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                    if (!auctionData.has("id")) continue;
                    knownIDs.add(auctionData.get("id").getAsString());
                }
                for (i = 1; i < Integer.MAX_VALUE; ++i) {
                    String genID = GENERATE_ID_FORMAT + String.valueOf(i);
                    if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                    persistentAuctions.add((JsonElement)message.getAuctionJson(genID));
                    TradingOffice.setPersistentTraderSection("Auctions", persistentAuctions);
                    player.m_6352_((Component)new TranslatableComponent("lightmanscurrency.message.persistent.auction.add", new Object[]{genID}), new UUID(0L, 0L));
                    return;
                }
                LightmansCurrency.LogError("Could not generate ID, as all auction_# ID's are somehow spoken for.");
            }
            player.m_6352_((Component)new TranslatableComponent("lightmanscurrency.message.persistent.auction.fail"), new UUID(0L, 0L));
        });
        supplier.get().setPacketHandled(true);
    }
}

