/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.interfacing;

import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.trader.ITradeSource;
import io.github.lightman314.lightmanscurrency.trader.interfacing.UniversalTraderReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UniversalTradeReference
extends UniversalTraderReference {
    private Function<CompoundTag, TradeData> tradeDeserializer;
    private int tradeIndex = -1;
    private TradeData tradeData = null;

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public boolean hasTrade() {
        return this.tradeIndex >= 0 && this.tradeData != null;
    }

    public TradeData getLocalTrade() {
        return this.tradeData;
    }

    public void setTrade(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.tradeData = this.copyTrade(this.getTrueTrade());
        if (this.tradeData == null) {
            this.tradeIndex = -1;
        }
    }

    public void refreshTrade() {
        if (!this.hasTrade()) {
            return;
        }
        TradeData newTrade = this.copyTrade(this.getTrueTrade());
        if (newTrade != null) {
            this.tradeData = newTrade;
        }
    }

    public TradeData copyTrade(TradeData trade) {
        if (trade == null) {
            return null;
        }
        return this.tradeDeserializer.apply(trade.getAsNBT());
    }

    public UniversalTradeReference(Supplier<Boolean> clientCheck, Function<CompoundTag, TradeData> tradeDeserializer) {
        super(clientCheck);
        this.tradeDeserializer = tradeDeserializer;
    }

    public TradeData getTrueTrade() {
        if (this.tradeIndex < 0) {
            return null;
        }
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof ITradeSource) {
            ITradeSource tradeSource = (ITradeSource)((Object)trader);
            return tradeSource.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = super.save();
        if (this.tradeData != null && this.tradeIndex >= 0) {
            compound.m_128405_("tradeIndex", this.tradeIndex);
            compound.m_128365_("trade", (Tag)this.tradeData.getAsNBT());
        }
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.m_128425_("tradeIndex", 3)) {
            this.tradeIndex = compound.m_128451_("tradeIndex");
        }
        if (compound.m_128425_("trade", 10)) {
            this.tradeData = this.tradeDeserializer.apply(compound.m_128469_("trade"));
        }
    }
}

