/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemShopLogger
extends TextLogger {
    public ItemShopLogger() {
        super("ItemShopHistory");
    }

    @Deprecated
    public void AddLog(Player player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        this.AddLog(PlayerReference.of(player), trade, pricePaid, isCreative);
    }

    public void AddLog(PlayerReference player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        MutableComponent creativeText = ItemShopLogger.getCreativeText(isCreative);
        MutableComponent playerName = ItemShopLogger.getPlayerText(player);
        MutableComponent boughtText = Component.m_237115_((String)("log.shoplog." + trade.getTradeType().name().toLowerCase()));
        Component itemText = trade.isPurchase() ? ItemShopLogger.getItemInputComponent(trade.getSellItem(0), trade.getSellItem(1)) : ItemShopLogger.getItemOutputComponent(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1));
        MutableComponent cost = ItemShopLogger.getCostText(pricePaid);
        if (trade.isBarter()) {
            cost = itemText;
            itemText = ItemShopLogger.getItemInputComponent(trade.getBarterItem(0), trade.getBarterItem(1));
        }
        this.AddLog(Component.m_237110_((String)"log.shoplog.item.format", (Object[])new Object[]{creativeText, playerName, boughtText, itemText, cost}));
    }

    public static Component getItemInputComponent(ItemStack item1, ItemStack item2) {
        return ItemShopLogger.getItemOutputComponent(item1, "", item2, "");
    }

    public static Component getItemOutputComponent(ItemStack item1, String customName1, ItemStack item2, String customName2) {
        if (item1.m_41619_() && item2.m_41619_()) {
            return Component.m_237119_();
        }
        if (item1.m_41619_() && !item2.m_41619_()) {
            return ItemShopLogger.getItemComponent(item2, customName2);
        }
        if (!item1.m_41619_() && item2.m_41619_()) {
            return ItemShopLogger.getItemComponent(item1, customName1);
        }
        return Component.m_237110_((String)"log.shoplog.and", (Object[])new Object[]{ItemShopLogger.getItemComponent(item1, customName1), ItemShopLogger.getItemComponent(item2, customName2)});
    }

    public static Component getItemComponent(ItemStack item, String customName) {
        MutableComponent itemName = Component.m_237119_().m_7220_((Component)(customName.isBlank() ? item.m_41786_() : Component.m_237113_((String)customName))).m_130938_(item.m_41791_().getStyleModifier());
        if (item.m_41788_() && customName.isBlank()) {
            itemName.m_130940_(ChatFormatting.ITALIC);
        }
        return Component.m_237110_((String)"log.shoplog.item.itemformat", (Object[])new Object[]{item.m_41613_(), itemName});
    }
}

