/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PaygateLogger
extends TextLogger {
    public PaygateLogger() {
        super("PaygateHistory");
    }

    public void AddLog(PlayerReference player, PaygateTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        MutableComponent creativeText = PaygateLogger.getCreativeText(isCreative);
        MutableComponent playerName = PaygateLogger.getPlayerText(player);
        MutableComponent durationText = PaygateTradeData.formatDurationShort(trade.getDuration());
        if (trade.isTicketTrade()) {
            this.AddLog(Component.m_237110_((String)"log.shoplog.paygate.format.ticket", (Object[])new Object[]{creativeText, playerName, trade.getTicketID().toString(), durationText}));
        } else {
            this.AddLog(Component.m_237110_((String)"log.shoplog.paygate.format.coin", (Object[])new Object[]{creativeText, playerName, PaygateLogger.getCostText(pricePaid), durationText}));
        }
    }
}

