/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SettingsLogger
extends TextLogger {
    public SettingsLogger() {
        super("SettingsHistory");
    }

    public static final MutableComponent getEnableDisableText(boolean enabled, ChatFormatting enableFormat, ChatFormatting disableFormat) {
        return Component.m_237115_((String)("log.settings." + (enabled ? "enabled" : "disabled"))).m_130940_(enabled ? enableFormat : disableFormat);
    }

    public static final MutableComponent getToFromText(boolean enabled, ChatFormatting ... format) {
        return Component.m_237115_((String)("log.settings." + (enabled ? "to" : "from"))).m_130944_(format);
    }

    public static final MutableComponent getAddRemoveText(boolean added, ChatFormatting addFormat, ChatFormatting removeFormat) {
        return Component.m_237115_((String)("log.settings." + (added ? "add" : "remove"))).m_130940_(added ? addFormat : removeFormat);
    }

    public static final MutableComponent getPlayerName(Player player) {
        return Component.m_237113_((String)player.m_7755_().getString()).m_130940_(ChatFormatting.GREEN);
    }

    public static final MutableComponent getTeamName(Team team) {
        if (team != null) {
            return Component.m_237113_((String)team.getName()).m_130940_(ChatFormatting.GREEN);
        }
        return Component.m_237113_((String)"NULL");
    }

    public static final MutableComponent getPlayerName(PlayerReference player) {
        return Component.m_237113_((String)player.lastKnownName()).m_130940_(ChatFormatting.GREEN);
    }

    public static final MutableComponent format(Object value, ChatFormatting ... format) {
        return Component.m_237113_((String)value.toString()).m_130944_(format);
    }

    public void LogNameChange(Player player, String oldName, String newName) {
        if (player == null) {
            return;
        }
        if (oldName.isEmpty()) {
            this.AddLog(Component.m_237110_((String)"log.settings.changename.set", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(newName, ChatFormatting.GOLD)}));
        } else if (newName.isEmpty()) {
            this.AddLog(Component.m_237110_((String)"log.settings.changename.reset", (Object[])new Object[]{SettingsLogger.getPlayerName(player)}));
        } else {
            this.AddLog(Component.m_237110_((String)"log.settings.changename", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(oldName, ChatFormatting.GOLD), SettingsLogger.format(newName, ChatFormatting.GOLD)}));
        }
    }

    public void LogOwnerChange(Player player, PlayerReference oldOwner, PlayerReference newOwner) {
        if (player == null) {
            return;
        }
        if (oldOwner.is((Entity)player)) {
            this.AddLog(Component.m_237110_((String)"log.settings.newowner.passed", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(newOwner)}));
        } else if (newOwner.is((Entity)player)) {
            this.AddLog(Component.m_237110_((String)"log.settings.newowner.taken", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner)}));
        } else {
            this.AddLog(Component.m_237110_((String)"log.settings.newowner.transferred", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner), SettingsLogger.getPlayerName(newOwner)}));
        }
    }

    public void LogTeamChange(Player player, PlayerReference owner, Team oldTeam, Team newTeam) {
        if (player == null || owner == null) {
            return;
        }
        if (oldTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog(Component.m_237110_((String)"log.settings.newowner.passed", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(newTeam)}));
            } else {
                this.AddLog(Component.m_237110_((String)"log.settings.newowner.transferred", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(owner), SettingsLogger.getTeamName(newTeam)}));
            }
        } else if (newTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog(Component.m_237110_((String)"log.settings.newowner.taken", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam)}));
            } else {
                this.AddLog(Component.m_237110_((String)"log.settings.newowner.transferred", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getPlayerName(owner)}));
            }
        } else {
            this.AddLog(Component.m_237110_((String)"log.settings.newowner.transferred", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getTeamName(newTeam)}));
        }
    }

    public void LogCreativeToggle(Player player, boolean isNowCreative) {
        this.AddLog(Component.m_237110_((String)"log.settings.creativemode", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getEnableDisableText(isNowCreative, ChatFormatting.GREEN, ChatFormatting.RED)}));
    }

    public void LogAddRemoveTrade(Player player, boolean added, int newCount) {
        this.AddLog(Component.m_237110_((String)"log.settings.addremovetrade", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, ChatFormatting.GOLD, ChatFormatting.GOLD), SettingsLogger.format(newCount, ChatFormatting.GOLD)}));
    }

    public void LogAllyChange(Player player, PlayerReference ally, boolean added) {
        this.AddLog(Component.m_237110_((String)"log.settings.addremoveally", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, ChatFormatting.GOLD, ChatFormatting.GOLD), SettingsLogger.getPlayerName(ally), SettingsLogger.getToFromText(added, new ChatFormatting[0])}));
    }

    public void LogAllyPermissionChange(Player player, String permission, Object oldValue, Object newValue) {
        this.AddLog(Component.m_237110_((String)"log.settings.permission.ally", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, ChatFormatting.GOLD), SettingsLogger.format(oldValue, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogAllyPermissionChange(Player player, String permission, Object newValue) {
        this.AddLog(Component.m_237110_((String)"log.settings.permission.ally.simple", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogSettingsChange(Player player, String setting, Object oldValue, Object newValue) {
        this.AddLog(Component.m_237110_((String)"log.settings.change", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, ChatFormatting.GOLD), SettingsLogger.format(oldValue, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogSettingsChange(Player player, String setting, Object newValue) {
        this.AddLog(Component.m_237110_((String)"log.settings.change.simple", (Object[])new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogText(MutableComponent text) {
        this.AddLog(text);
    }
}

