/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.handler.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.upgrades.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity
implements TraderItemStorage.ITraderItemFilter {
    public static final int BUFFER_SIZE = 9;
    private TraderItemStorage itemBuffer = new TraderItemStorage(this);
    ItemInterfaceHandler itemHandler = this.addHandler(new ItemInterfaceHandler(this, this::getItemBuffer));

    public TraderItemStorage getItemBuffer() {
        return this.itemBuffer;
    }

    public ItemInterfaceHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemTraderInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRADER_INTERFACE_ITEM.get(), pos, state);
    }

    @Override
    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withItemHandler(this.itemBuffer);
    }

    public boolean allowInput(ItemStack item) {
        if (this.getInteractionType().trades) {
            TradeData t = this.getReferencedTrade();
            if (t instanceof ItemTradeData) {
                ItemTradeData trade = (ItemTradeData)t;
                if (trade.isBarter()) {
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getBarterItem(i))) continue;
                        return true;
                    }
                } else if (trade.isPurchase()) {
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof IItemTrader) {
            for (ItemTradeData trade : ((IItemTrader)((Object)trader)).getAllTrades()) {
                if (!trade.isSale() && !trade.isBarter()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean allowOutput(ItemStack item) {
        return !this.allowInput(item);
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        if (this.getInteractionType().trades) {
            TradeData t = this.getReferencedTrade();
            if (t instanceof ItemTradeData) {
                ItemTradeData trade = (ItemTradeData)t;
                return trade.allowItemInStorage(item);
            }
            return false;
        }
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof IItemTrader) {
            for (ItemTradeData trade : ((IItemTrader)((Object)trader)).getAllTrades()) {
                if (!trade.allowItemInStorage(item)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgradeInventory().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgradeInventory().m_8020_(i);
            if (!(stack.m_41720_() instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)stack.m_41720_()) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    protected ItemTradeData deserializeTrade(CompoundTag compound) {
        return ItemTradeData.loadData(compound);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveItemBuffer(compound);
    }

    protected final CompoundTag saveItemBuffer(CompoundTag compound) {
        this.itemBuffer.save(compound, "Storage");
        return compound;
    }

    public void setItemBufferDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveItemBuffer(new CompoundTag()));
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Storage")) {
            this.itemBuffer.load(compound, "Storage");
        }
    }

    @Override
    public boolean validTraderType(UniversalTraderData trader) {
        return trader instanceof IItemTrader;
    }

    protected final IItemTrader getItemTrader() {
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof IItemTrader) {
            return (IItemTrader)((Object)trader);
        }
        return null;
    }

    @Override
    protected void drainTick() {
        IItemTrader trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner, "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid()) continue;
                ArrayList<ItemStack> drainItems = new ArrayList<ItemStack>();
                if (trade.isPurchase()) {
                    drainItems.add(trade.getSellItem(0));
                    drainItems.add(trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    drainItems.add(trade.getBarterItem(0));
                    drainItems.add(trade.getBarterItem(1));
                }
                for (ItemStack drainItem : drainItems) {
                    int drainableAmount;
                    if (drainItem.m_41619_() || (drainableAmount = trader.getStorage().getItemCount(drainItem)) <= 0) continue;
                    ItemStack movingStack = drainItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), drainableAmount));
                    ItemStack removed = trader.getStorage().removeItem(movingStack);
                    ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemBuffer, (ItemStack)removed, (boolean)false);
                    if (!leftovers.m_41619_()) {
                        trader.getStorage().forceAddItem(leftovers);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void restockTick() {
        IItemTrader trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner, "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = (ItemTradeData)trader.getTrade(i);
                if (!trade.isValid() || !trade.isBarter() && !trade.isSale()) continue;
                for (int s = 0; s < 2; ++s) {
                    int stockableAmount;
                    ItemStack stockItem = trade.getSellItem(s);
                    if (stockItem.m_41619_() || (stockableAmount = this.itemBuffer.getItemCount(stockItem)) <= 0) continue;
                    ItemStack movingStack = stockItem.m_41777_();
                    movingStack.m_41764_(Math.min(movingStack.m_41741_(), stockableAmount));
                    ItemStack removedItem = this.itemBuffer.removeItem(movingStack);
                    if (removedItem.m_41613_() == movingStack.m_41613_()) {
                        trader.getStorage().tryAddItem(movingStack);
                        if (!movingStack.m_41619_()) {
                            this.itemBuffer.forceAddItem(movingStack);
                        }
                    } else {
                        this.itemBuffer.forceAddItem(removedItem);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void tradeTick() {
        ItemTradeData trade;
        TradeData t = this.getTrueTrade();
        if (t instanceof ItemTradeData && (trade = (ItemTradeData)t) != null && trade.isValid()) {
            if (trade.isSale()) {
                if (this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isPurchase()) {
                if (this.itemBuffer.hasItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isBarter() && this.itemBuffer.hasItems(trade.getBarterItem(0), trade.getBarterItem(1)) && this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                this.interactWithTrader();
                this.setItemBufferDirty();
            }
        }
    }

    @Override
    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
    }

    @Override
    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return type == UpgradeType.ITEM_CAPACITY;
    }

    @Override
    public void dumpContents(List<ItemStack> contents) {
        contents.addAll(this.itemBuffer.getSplitContents());
    }

    @Override
    public MutableComponent getName() {
        return Component.m_237115_((String)"block.lightmanscurrency.item_trader_interface");
    }
}

