/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import io.github.lightman314.lightmanscurrency.network.message.logger.MessageClearLogger;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageChangeSettings;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenStorage;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenTrades;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageRequestSyncUsers;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageSyncUsers;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public abstract class TraderBlockEntity
extends TickableBlockEntity
implements IOwnableBlockEntity,
ITrader {
    CoreTraderSettings coreSettings = new CoreTraderSettings(this, this::markCoreSettingsDirty, this::sendSettingsUpdateToServer);
    protected CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private List<Player> users = new ArrayList<Player>();
    private int userCount = 0;
    private boolean versionUpdate = false;
    private int oldVersion = 0;
    private boolean allowRemoval = false;

    public boolean allowRemoval() {
        return this.allowRemoval;
    }

    public void flagAsRemovable() {
        this.allowRemoval = true;
    }

    protected TraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public TraderCategory getNotificationCategory() {
        if (this.f_58857_ != null) {
            return new TraderCategory((ItemLike)this.f_58857_.m_8055_(this.f_58858_).m_60734_(), this.getName());
        }
        return new TraderCategory((ItemLike)ModItems.TRADING_CORE.get(), this.getName());
    }

    @Override
    public void userOpen(Player player) {
        if (!this.users.contains(player)) {
            this.users.add(player);
            this.sendUserUpdate();
        }
    }

    @Override
    public void userClose(Player player) {
        if (this.users.contains(player)) {
            this.users.remove(player);
            this.sendUserUpdate();
        }
    }

    public int getUserCount() {
        if (this.f_58857_.f_46443_) {
            return this.userCount;
        }
        return this.users.size();
    }

    protected List<Player> getUsers() {
        return this.users;
    }

    private void sendUserUpdate() {
        if (!this.f_58857_.f_46443_) {
            LevelChunk chunk = (LevelChunk)this.f_58857_.m_46865_(this.f_58858_);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new MessageSyncUsers(this.f_58858_, this.getUserCount()));
        }
    }

    public void setUserCount(int value) {
        this.userCount = value;
    }

    @Override
    public CoreTraderSettings getCoreSettings() {
        return this.coreSettings;
    }

    @Override
    public void markCoreSettingsDirty() {
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeCoreSettings(new CompoundTag()));
        }
        this.m_6596_();
    }

    protected final void sendSettingsUpdateToServer(ResourceLocation type, CompoundTag updateInfo) {
        if (this.f_58857_.f_46443_) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageChangeSettings(this.f_58858_, type, updateInfo));
        }
    }

    public final void changeSettings(ResourceLocation type, Player requestor, CompoundTag updateInfo) {
        if (this.f_58857_.f_46443_) {
            LightmansCurrency.LogError("TraderTileEntity.changeSettings was called on a client.");
        }
        if (type.equals((Object)this.coreSettings.getType())) {
            this.coreSettings.changeSetting(requestor, updateInfo);
        } else {
            this.getAdditionalSettings().forEach(setting -> {
                if (type.equals((Object)setting.getType())) {
                    setting.changeSetting(requestor, updateInfo);
                }
            });
        }
    }

    public void initOwner(PlayerReference player) {
        this.coreSettings.initializeOwner(player);
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade(this.f_58858_, isAdd));
        }
    }

    @Override
    public boolean canBreak(Player player) {
        return this.hasPermission(player, "breakTrader");
    }

    @Override
    public CoinValue getStoredMoney() {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            return account.getCoinStorage().copy();
        }
        return this.storedMoney;
    }

    @Override
    public CoinValue getInternalStoredMoney() {
        return this.storedMoney;
    }

    @Override
    public void addStoredMoney(CoinValue addedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.depositCoins(addedAmount);
            account.LogInteraction(this, addedAmount, true);
            return;
        }
        this.storedMoney.addValue(addedAmount);
        this.markMoneyDirty();
    }

    @Override
    public void removeStoredMoney(CoinValue removedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.withdrawCoins(removedAmount);
            account.LogInteraction(this, removedAmount, false);
            return;
        }
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        this.markMoneyDirty();
    }

    @Override
    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.markMoneyDirty();
    }

    @Override
    public void markMoneyDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeStoredMoney(new CompoundTag()));
        }
    }

    @Override
    public void serverTick() {
        if (this.versionUpdate && this.f_58857_ != null) {
            this.versionUpdate = false;
            this.onVersionUpdate(this.oldVersion);
        }
    }

    @Override
    public MutableComponent getDefaultName() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public MenuProvider getTradeMenuProvider() {
        return new TradeMenuProvider<TraderBlockEntity>(this);
    }

    @Override
    public void openTradeMenu(Player player) {
        MenuProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade menu container provider was given for the trader of type " + BlockEntityType.m_58954_((BlockEntityType)this.m_58903_()).toString());
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
    }

    public MenuProvider getStorageMenuProvider() {
        return new TradeStorageMenuProvider<TraderBlockEntity>(this);
    }

    @Override
    public void openStorageMenu(Player player) {
        if (!this.hasPermission(player, "openStorage")) {
            Settings.PermissionWarning(player, "open trader storage", "openStorage");
            return;
        }
        MenuProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the trader of type " + BlockEntityType.m_58954_((BlockEntityType)this.m_58903_()));
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the storage menu.");
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeCoreSettings(compound);
        this.writeStoredMoney(compound);
        this.writeVersion(compound);
        super.m_183515_(compound);
    }

    protected CompoundTag writeStoredMoney(CompoundTag compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected CompoundTag writeCoreSettings(CompoundTag compound) {
        compound.m_128365_("CoreSettings", (Tag)this.coreSettings.save(new CompoundTag()));
        return compound;
    }

    protected CompoundTag writeVersion(CompoundTag compound) {
        compound.m_128405_("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("CoreSettings", 10)) {
            this.coreSettings.load(compound.m_128469_("CoreSettings"));
        } else if (compound.m_128441_("OwnerID")) {
            this.coreSettings.loadFromOldTraderData(compound);
        }
        this.storedMoney.readFromNBT(compound, "StoredMoney");
        if (compound.m_128425_("TraderVersion", 3)) {
            this.oldVersion = compound.m_128451_("TraderVersion");
        }
        if (this.oldVersion < this.GetCurrentVersion()) {
            this.versionUpdate = true;
        }
        super.m_142466_(compound);
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(this));
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestSyncUsers(this.f_58858_));
        }
    }

    @Override
    public final List<ItemStack> dumpContents(BlockState state, boolean dropBlock) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (dropBlock) {
            if (state.m_60734_() instanceof ITraderBlock) {
                contents.add(((ITraderBlock)state.m_60734_()).getDropBlockItem(state, this));
            } else {
                contents.add(new ItemStack((ItemLike)state.m_60734_()));
            }
        }
        contents.addAll(MoneyUtil.getCoinsOfValue(this.storedMoney));
        this.dumpContents(contents);
        return contents;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public boolean isClient() {
        if (this.f_58857_ == null) {
            return true;
        }
        return this.f_58857_.f_46443_;
    }

    @Override
    public void sendOpenTraderMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades(this.f_58858_));
        }
    }

    @Override
    public void sendOpenStorageMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.f_58858_));
        }
    }

    @Override
    public void sendClearLogMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageClearLogger(this.f_58858_));
        }
    }

    public static class TradeMenuProvider<T extends BlockEntity>
    implements MenuProvider {
        T trader;

        public TradeMenuProvider(T trader) {
            this.trader = trader;
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new TraderMenu(id, inventory, this.trader.m_58899_());
        }
    }

    public static class TradeStorageMenuProvider<T extends BlockEntity>
    implements MenuProvider {
        T trader;

        public TradeStorageMenuProvider(T trader) {
            this.trader = trader;
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
            return new TraderStorageMenu(id, inventory, this.trader.m_58899_());
        }
    }
}

