/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.blockentity.CoinMintBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.menus.MintMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class CoinMintBlock
extends RotatableBlock
implements EntityBlock {
    private static final MutableComponent TITLE = Component.m_237115_((String)"gui.lightmanscurrency.coinmint.title");

    public CoinMintBlock(BlockBehaviour.Properties properties) {
        super(properties, CoinMintBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CoinMintBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileEntity;
        if (!level.f_46443_ && ((tileEntity = level.m_7702_(pos)) instanceof CoinMintBlockEntity && ((Boolean)Config.SERVER.allowCoinMinting.get()).booleanValue() || ((Boolean)Config.SERVER.allowCoinMelting.get()).booleanValue())) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new CoinMintMenuProvider((CoinMintBlockEntity)tileEntity), (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.allowCoinMinting.get()).booleanValue() || ((Boolean)Config.SERVER.allowCoinMelting.get()).booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinMintBlockEntity) {
            CoinMintBlockEntity mintEntity = (CoinMintBlockEntity)blockEntity;
            mintEntity.dumpContents(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCTooltips.COIN_MINT);
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    private static class CoinMintMenuProvider
    implements MenuProvider {
        private final CoinMintBlockEntity tileEntity;

        public CoinMintMenuProvider(CoinMintBlockEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new MintMenu(id, inventory, this.tileEntity);
        }

        public Component m_5446_() {
            return TITLE;
        }
    }
}

