/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates.TraderBlockBase;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

public class DisplayCaseBlock
extends TraderBlockBase
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;

    public DisplayCaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 1);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.ITEM_TRADER.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleTrade) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        posList.add(new Vector3f(0.5f, 0.625f, 0.5f));
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 0.75f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }

    @Override
    public Direction getRelativeSide(BlockState state, Direction side) {
        return side;
    }

    @Override
    public ItemInterfaceBlockEntity.IItemHandlerBlockEntity getItemHandlerEntity(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof ItemInterfaceBlockEntity.IItemHandlerBlockEntity) {
            return (ItemInterfaceBlockEntity.IItemHandlerBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }

    @Override
    protected void onInvalidRemoval(BlockState state, Level level, BlockPos pos, TraderBlockEntity trader) {
    }
}

