/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class TraderBlockBase
extends Block
implements ITraderBlock,
EntityBlock {
    private final VoxelShape shape;

    public TraderBlockBase(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.BOX_T);
    }

    public TraderBlockBase(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.shape = shape != null ? shape : LazyShapes.BOX_T;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected boolean shouldMakeTrader(BlockState state) {
        return true;
    }

    protected abstract BlockEntity makeTrader(BlockPos var1, BlockState var2);

    protected BlockEntity makeDummy(BlockPos pos, BlockState state) {
        return null;
    }

    protected abstract BlockEntityType<?> traderType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTickerHelper(type, this.traderType(), TickableBlockEntity::tickHandler);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.shouldMakeTrader(state)) {
            return this.makeTrader(pos, state);
        }
        return this.makeDummy(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity trader = (TraderBlockEntity)blockEntity;
            BlockEntityUtil.sendUpdatePacket(blockEntity);
            trader.openTradeMenu(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    public final void setPlacedByBase(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        if (!level.f_46443_) {
            BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity trader = (TraderBlockEntity)blockEntity;
                trader.initOwner(PlayerReference.of((Entity)player));
                if (stack.m_41788_()) {
                    trader.getCoreSettings().setCustomName(null, stack.m_41786_().getString());
                }
            } else {
                LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when placing the block.");
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.playerWillDestroyBase(level, pos, state, player);
    }

    public final void playerWillDestroyBase(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity) {
            TraderBlockEntity trader = (TraderBlockEntity)blockEntity;
            if (!trader.canBreak(player)) {
                return;
            }
            trader.flagAsRemovable();
            InventoryUtil.dumpContents(level, pos, trader.dumpContents(state, !player.m_7500_()));
        } else {
            LightmansCurrency.LogError("Trader Block returned block entity of type '" + (blockEntity == null ? "null" : blockEntity.getClass().getName()) + "' when destroying the block.");
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean flag) {
        BlockEntity blockEntity;
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof TraderBlockEntity) {
            TraderBlockEntity trader = (TraderBlockEntity)blockEntity;
            if (!trader.allowRemoval()) {
                LightmansCurrency.LogError("Trader block at " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " was broken by illegal means!");
                LightmansCurrency.LogError("Activating emergency eject protocol.");
                EjectionData data = EjectionData.create(state, trader);
                TradingOffice.handleEjectionData(level, pos, data);
                trader.flagAsRemovable();
                try {
                    this.onInvalidRemoval(state, level, pos, trader);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                LightmansCurrency.LogInfo("Trader block was broken by legal means!");
            }
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(BlockState var1, Level var2, BlockPos var3, TraderBlockEntity var4);

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    @Override
    public BlockEntity getBlockEntity(BlockState state, LevelAccessor level, BlockPos pos) {
        return level.m_7702_(pos);
    }

    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return () -> new ArrayList();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.m_5871_(stack, level, tooltip, flagIn);
    }
}

