/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.MarkAsSeenButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.NotificationTabButton;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.notifications.MessageFlagNotificationsSeen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.util.NonNullSupplier;

public class NotificationScreen
extends Screen
implements ScrollBarWidget.IScrollable {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/notifications.png");
    public final int xSize = 200;
    public final int ySize = 200;
    public final int TABS_PER_PAGE = 8;
    public final int NOTIFICATIONS_PER_PAGE = 8;
    public final int NOTIFICATION_HEIGHT = 22;
    List<NotificationTabButton> tabButtons;
    int tabScroll = 0;
    Notification.Category selectedCategory = Notification.Category.GENERAL;
    ScrollBarWidget notificationScroller = null;
    Button buttonMarkAsSeen;
    int notificationScroll = 0;

    public final NotificationData getNotifications() {
        return ClientTradingOffice.getNotifications();
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.f_96543_ - 200 - 25) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.f_96544_ - 200) / 2;
    }

    public NotificationScreen() {
        super((Component)Component.m_237119_());
    }

    public boolean m_7043_() {
        return false;
    }

    public List<Notification.Category> getCategories() {
        ArrayList categories = Lists.newArrayList((Object[])new Notification.Category[]{Notification.Category.GENERAL});
        categories.addAll(this.getNotifications().getCategories().stream().filter(cat -> cat != Notification.Category.GENERAL).collect(Collectors.toList()));
        return categories;
    }

    public void reinit() {
        this.m_169413_();
        this.validateSelectedCategory();
        this.m_7856_();
    }

    public void m_7856_() {
        this.tabButtons = new ArrayList<NotificationTabButton>();
        for (Notification.Category cat : this.getCategories()) {
            this.tabButtons.add((NotificationTabButton)this.m_142416_((GuiEventListener)new NotificationTabButton(this::SelectTab, this.f_96547_, (NonNullSupplier<NotificationData>)((NonNullSupplier)this::getNotifications), cat)));
        }
        this.positionTabButtons();
        int n = this.guiLeft() + 25;
        Objects.requireNonNull(this);
        int n2 = n + 200 - 15;
        int n3 = this.guiTop() + 15;
        Objects.requireNonNull(this);
        this.notificationScroller = (ScrollBarWidget)this.m_169394_((Widget)new ScrollBarWidget(n2, n3, 8 * this.NOTIFICATION_HEIGHT, this));
        int n4 = this.guiLeft();
        Objects.requireNonNull(this);
        this.buttonMarkAsSeen = (Button)this.m_142416_((GuiEventListener)new MarkAsSeenButton(n4 + 200 + 25 - 15, this.guiTop() + 4, (Component)Component.m_237115_((String)"gui.button.notifications.mark_read"), this::markAsRead));
        this.m_86600_();
    }

    private void validateSelectedCategory() {
        List<Notification.Category> categories = this.getCategories();
        boolean categoryFound = false;
        for (int i = 0; i < categories.size() && !categoryFound; ++i) {
            if (!categories.get(i).matches(this.selectedCategory)) continue;
            categoryFound = true;
        }
        if (!categoryFound || this.selectedCategory == null) {
            this.selectedCategory = Notification.Category.GENERAL;
        }
    }

    private void positionTabButtons() {
        int startIndex = this.tabScroll = Math.min(this.tabScroll, this.getMaxTabScroll());
        int xPos = this.guiLeft();
        int yPos = this.guiTop();
        List<Notification.Category> categories = this.getCategories();
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton tab = this.tabButtons.get(i);
            if (i >= startIndex && i < startIndex + 8) {
                tab.f_93624_ = true;
                tab.reposition(xPos, yPos, 3);
                tab.f_93623_ = i < categories.size() ? !categories.get(i).matches(this.selectedCategory) : true;
                yPos += 25;
                continue;
            }
            tab.f_93624_ = false;
        }
    }

    public void m_86600_() {
        this.buttonMarkAsSeen.f_93623_ = this.getNotifications().unseenNotification(this.selectedCategory);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int screenLeft = this.guiLeft() + 25;
        int n = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.m_93228_(pose, screenLeft, n, 0, 0, 200, 200);
        this.notificationScroller.beforeWidgetRender(mouseY);
        this.notificationScroll = Math.min(this.notificationScroll, this.getMaxNotificationScroll());
        List<Notification> notifications = this.getNotifications().getNotifications(this.selectedCategory);
        MutableComponent tooltip = null;
        int index = this.notificationScroll;
        for (int y = 0; y < 8 && index < notifications.size(); ++y) {
            MutableComponent message;
            List lines;
            int n2;
            Notification not = notifications.get(index++);
            int yPos = this.guiTop() + 15 + y * 22;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (not.wasSeen()) {
                Objects.requireNonNull(this);
                n2 = 200;
            } else {
                Objects.requireNonNull(this);
                n2 = 200 + 22;
            }
            int vPos = n2;
            int textColor = not.wasSeen() ? 0xFFFFFF : 0;
            this.m_93228_(pose, screenLeft + 15, yPos, 0, vPos, 170, 22);
            int textXPos = screenLeft + 17;
            int textWidth = 166;
            if (not.getCount() > 1) {
                String countText = String.valueOf(not.getCount());
                int quantityWidth = this.f_96547_.m_92895_(countText);
                this.m_93228_(pose, screenLeft + 16 + quantityWidth, yPos, 170, vPos, 3, 22);
                float f = textXPos;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92883_(pose, countText, f, (float)(yPos + 11 - 9 / 2), textColor);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            if ((lines = this.f_96547_.m_92923_((FormattedText)(message = this.selectedCategory == Notification.Category.GENERAL ? not.getGeneralMessage() : not.getMessage()), textWidth)).size() == 1) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(0);
                float f = textXPos;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92877_(pose, formattedCharSequence, f, (float)(yPos + 11 - 9 / 2), textColor);
                continue;
            }
            for (int l = 0; l < lines.size() && l < 2; ++l) {
                this.f_96547_.m_92877_(pose, (FormattedCharSequence)lines.get(l), (float)textXPos, (float)(yPos + 2 + l * 10), textColor);
            }
            if (lines.size() <= 2 || tooltip != null || mouseX < screenLeft + 15 || mouseX >= screenLeft + 185 || mouseY < yPos || mouseY >= yPos + 22) continue;
            tooltip = message;
        }
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        for (NotificationTabButton tab : this.tabButtons) {
            tab.renderTooltip(pose, mouseX, mouseY, this);
        }
        if (tooltip != null) {
            this.m_96617_(pose, this.f_96547_.m_92923_(tooltip, 170), mouseX, mouseY);
        }
    }

    private void SelectTab(Button button) {
        Notification.Category newCategory;
        List<Notification.Category> categories;
        int tabIndex = this.tabButtons.indexOf(button);
        if (tabIndex >= 0 && tabIndex < (categories = this.getCategories()).size() && !(newCategory = categories.get(tabIndex)).matches(this.selectedCategory)) {
            this.selectedCategory = newCategory;
            this.notificationScroll = 0;
            this.positionTabButtons();
        }
    }

    public int getMaxTabScroll() {
        return Math.max(0, this.tabButtons.size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tabScrolled(double delta) {
        if (delta < 0.0) {
            if (this.tabScroll >= this.getMaxTabScroll()) return false;
            ++this.tabScroll;
            this.positionTabButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.tabScroll <= 0) return false;
            --this.tabScroll;
            this.positionTabButtons();
        }
        return true;
    }

    public int getMaxNotificationScroll() {
        return Math.max(0, this.getNotifications().getNotifications(this.selectedCategory).size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean notificationScrolled(double delta) {
        if (delta < 0.0) {
            if (this.notificationScroll >= this.getMaxNotificationScroll()) return false;
            ++this.notificationScroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.notificationScroll <= 0) return false;
            --this.notificationScroll;
        }
        return true;
    }

    public void markAsRead(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageFlagNotificationsSeen(this.selectedCategory));
    }

    @Override
    public int currentScroll() {
        return this.notificationScroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.notificationScroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return this.getMaxNotificationScroll();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)(this.guiLeft() + 25)) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            if (mouseX < (double)(n + 200) && mouseY >= (double)this.guiTop()) {
                int n2 = this.guiTop();
                Objects.requireNonNull(this);
                if (mouseY < (double)(n2 + 200)) {
                    if (this.notificationScrolled(delta)) {
                        return true;
                    }
                    return super.m_6050_(mouseX, mouseY, delta);
                }
            }
        }
        if (this.tabScrolled(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.notificationScroller.onMouseClicked(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.notificationScroller.onMouseReleased(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)key, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }
}

