/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamBankAccountTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamMemberEditTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamMemberListTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamNameTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamOwnerTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamSelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TeamManagerScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/teammanager.png");
    public final int xSize = 200;
    public final int ySize = 200;
    private UUID activeTeamID = null;
    List<AbstractWidget> tabWidgets = Lists.newArrayList();
    List<GuiEventListener> tabListeners = Lists.newArrayList();
    List<TeamTab> tabs = Lists.newArrayList((Object[])new TeamTab[]{TeamSelectionTab.INSTANCE, TeamMemberListTab.INSTANCE, TeamNameTab.INSTANCE, TeamMemberEditTab.INSTANCE, TeamBankAccountTab.INSTANCE, TeamOwnerTab.INSTANCE});
    List<TabButton> tabButtons = Lists.newArrayList();
    int currentTabIndex = 0;

    public TeamManagerScreen() {
        super((Component)Component.m_237119_());
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public Player getPlayer() {
        return this.f_96541_.f_91074_;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.f_96543_ - 200) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.f_96544_ - 200) / 2;
    }

    public Team getActiveTeam() {
        if (this.activeTeamID == null) {
            return null;
        }
        Team team = ClientTradingOffice.getTeam(this.activeTeamID);
        if (team != null && team.isMember(this.getPlayer())) {
            return team;
        }
        return null;
    }

    public void setActiveTeam(UUID teamID) {
        this.activeTeamID = teamID;
    }

    public TeamTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public void m_7856_() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this::clickedOnTab, this.f_96547_, this.tabs.get(i)));
            button.f_93623_ = i != this.currentTabIndex;
            button.f_93624_ = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        this.currentTab().initTab();
    }

    private int getTabPosX(int index) {
        if (index < 8) {
            return this.guiLeft() + 25 * index;
        }
        if (index < 16) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200;
        }
        if (index < 24) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 8) {
            return this.guiTop() - 25;
        }
        if (index < 16) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 24) {
            int n = this.guiTop();
            Objects.requireNonNull(this);
            return n + 200;
        }
        int n = this.guiTop();
        Objects.requireNonNull(this);
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 8) {
            return 0;
        }
        if (index < 16) {
            return 1;
        }
        if (index < 24) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton thisButton = this.tabButtons.get(i);
            if (!thisButton.f_93624_) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.m_93228_(pose, n, n2, 0, 0, 200, 200);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        try {
            this.currentTab().preRender(pose, mouseX, mouseY, partialTicks);
            this.tabWidgets.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
            this.currentTab().postRender(pose, mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).m_5953_(mouseX, mouseY)) continue;
            this.m_96602_(pose, (Component)this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void m_86600_() {
        if (this.activeTeamID == null && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            if (visible == this.tabButtons.get((int)i).f_93624_) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).f_93624_ = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        if (!this.currentTab().allowViewing(this.getPlayer(), this.getActiveTeam()) && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        this.currentTab().tick();
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(AbstractWidget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(GuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public void changeTab(int tabIndex) {
        if (!this.tabs.get(tabIndex).allowViewing(this.getPlayer(), this.getActiveTeam())) {
            return;
        }
        this.currentTab().closeTab();
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = true;
        this.currentTabIndex = tabIndex;
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().initTab();
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_7043_() {
        return false;
    }
}

