/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.InteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.SelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.menus.wallet.WalletBankMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageOpenWallet;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class WalletBankScreen
extends AbstractContainerScreen<WalletBankMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet_bank.png");
    int currentTabIndex = 0;
    List<WalletBankTab> tabs = Lists.newArrayList((Object[])new WalletBankTab[]{new InteractionTab(this), new SelectionTab(this)});
    List<AbstractWidget> tabWidgets = new ArrayList<AbstractWidget>();
    List<GuiEventListener> tabListeners = new ArrayList<GuiEventListener>();
    List<TabButton> tabButtons = new ArrayList<TabButton>();
    boolean logError = true;
    Button buttonOpenWallet;

    public List<WalletBankTab> getTabs() {
        return this.tabs;
    }

    public WalletBankTab currentTab() {
        return this.tabs.get(this.currentTabIndex);
    }

    public WalletBankScreen(WalletBankMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        this.f_97727_ = 128 + ((WalletBankMenu)this.f_97732_).getRowCount() * 18 + 7;
        this.f_97726_ = 176;
        super.m_7856_();
        this.m_169413_();
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.tabButtons = new ArrayList<TabButton>();
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this::clickedOnTab, this.f_96547_, this.tabs.get(i)));
            button.reposition(this.f_97735_ - 25, this.f_97736_ + i * 25, 3);
            button.f_93623_ = i != this.currentTabIndex;
            this.tabButtons.add(button);
        }
        this.buttonOpenWallet = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_, this.f_97736_ - 20, this::PressOpenWalletButton, IconData.of(((WalletBankMenu)this.f_97732_).getWallet())));
        this.currentTab().init();
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        block5: {
            int y;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, 128);
            for (y = 0; y < ((WalletBankMenu)this.f_97732_).getRowCount(); ++y) {
                this.m_93228_(pose, this.f_97735_, this.f_97736_ + 128 + y * 18, 0, 128, this.f_97726_, 18);
            }
            this.m_93228_(pose, this.f_97735_, this.f_97736_ + 128 + ((WalletBankMenu)this.f_97732_).getRowCount() * 18, 0, 146, this.f_97726_, 7);
            y = 0;
            while (y * 9 < ((WalletBankMenu)this.f_97732_).getSlotCount()) {
                for (int x = 0; x < 9 && x + y * 9 < ((WalletBankMenu)this.f_97732_).getSlotCount(); ++x) {
                    this.m_93228_(pose, this.f_97735_ + 7 + x * 18, this.f_97736_ + 128 + y * 18, 0, 153, 18, 18);
                }
                ++y;
            }
            try {
                this.currentTab().preRender(pose, mouseX, mouseY, partialTicks);
                this.tabWidgets.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
            }
            catch (Exception e) {
                if (!this.logError) break block5;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
    }

    private Component getWalletName() {
        ItemStack wallet = ((WalletBankMenu)this.f_97732_).getWallet();
        return wallet.m_41619_() ? Component.m_237119_() : wallet.m_41786_();
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.getWalletName(), 8.0f, 117.0f, 0x404040);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        block4: {
            this.m_7333_(pose);
            super.m_6305_(pose, mouseX, mouseY, partialTicks);
            try {
                this.currentTab().postRender(pose, mouseX, mouseY);
            }
            catch (Exception e) {
                if (!this.logError) break block4;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
        this.m_7025_(pose, mouseX, mouseY);
        if (this.buttonOpenWallet != null && this.buttonOpenWallet.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(pose, (Component)Component.m_237115_((String)"tooltip.lightmanscurrency.wallet.openwallet"), mouseX, mouseY);
        }
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).m_5953_(mouseX, mouseY)) continue;
            this.m_96602_(pose, (Component)this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void changeTab(int tabIndex) {
        this.currentTab().onClose();
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = true;
        this.currentTabIndex = MathUtil.clamp(tabIndex, 0, this.tabs.size() - 1);
        this.tabButtons.get((int)this.currentTabIndex).f_93623_ = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().init();
        this.logError = true;
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public void m_181908_() {
        this.currentTab().tick();
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(AbstractWidget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(GuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_97765_, (int)p_97766_);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.m_7933_(p_97765_, p_97766_, p_97767_);
    }

    private void PressOpenWalletButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenWallet(((WalletBankMenu)this.f_97732_).getWalletStackIndex()));
    }
}

