/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.base.InfoTab;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InfoClientTab
extends TraderInterfaceClientTab<InfoTab> {
    TradeButton tradeDisplay;
    TradeButton newTradeDisplay;
    ScrollTextDisplay changesDisplay;
    DropdownWidget interactionDropdown;
    Button acceptChangesButton;

    public InfoClientTab(TraderInterfaceScreen screen, InfoTab tab) {
        super(screen, tab);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.interface.info");
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getTradeContext, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE()::getReferencedTrade, TradeButton.NULL_PRESS));
        this.tradeDisplay.move(this.screen.getGuiLeft() + 6, this.screen.getGuiTop() + 20);
        this.tradeDisplay.displayOnly = true;
        this.newTradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getTradeContext, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE()::getTrueTrade, TradeButton.NULL_PRESS));
        this.newTradeDisplay.f_93624_ = false;
        this.newTradeDisplay.displayOnly = true;
        this.interactionDropdown = this.screen.addRenderableTabWidget(IconAndButtonUtil.interactionTypeDropdown(this.screen.getGuiLeft() + 104, this.screen.getGuiTop() + 20, 97, this.font, ((TraderInterfaceMenu)this.screen.m_6262_()).getBE().getInteractionType(), this::onInteractionSelect, this.screen::addRenderableTabWidget, this.menu.getBE().getBlacklistedInteractions()));
        this.changesDisplay = this.screen.addRenderableTabWidget(new ScrollTextDisplay(this.screen.getGuiLeft() + 104, this.screen.getGuiTop() + 36, 97, 73, this.font, (Supplier<List<? extends Component>>)((Supplier)this::getMessages)));
        this.changesDisplay.backgroundColor = 0;
        this.acceptChangesButton = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize(), this.screen.getGuiTop() + 40, this::AcceptTradeChanges, IconAndButtonUtil.ICON_CHECKMARK, (Button.OnTooltip)new IconAndButtonUtil.SimpleTooltip((Component)Component.m_237115_((String)"tooltip.lightmanscurrency.interface.info.acceptchanges"))));
        this.acceptChangesButton.f_93624_ = false;
    }

    private List<Component> getMessages() {
        UniversalTraderData trader;
        if (this.menu.getBE() == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> list = new ArrayList<Component>();
        TradeContext.TradeResult result = this.menu.getBE().mostRecentTradeResult();
        if (result.failMessage != null) {
            list.add(result.failMessage);
        }
        if (this.menu.getBE().getInteractionType().trades) {
            TradeData referencedTrade = this.menu.getBE().getReferencedTrade();
            TradeData trueTrade = this.menu.getBE().getTrueTrade();
            if (referencedTrade == null) {
                return new ArrayList<Component>();
            }
            if (trueTrade == null) {
                list.add((Component)Component.m_237115_((String)"gui.lightmanscurrency.interface.difference.missing").m_130940_(ChatFormatting.RED));
                return list;
            }
            TradeData.TradeComparisonResult differences = referencedTrade.compare(trueTrade);
            if (!differences.TypeMatches()) {
                list.add((Component)Component.m_237115_((String)"gui.lightmanscurrency.interface.difference.type").m_130940_(ChatFormatting.RED));
                return list;
            }
            list.addAll(referencedTrade.GetDifferenceWarnings(differences));
            return list;
        }
        if (this.menu.getBE().getInteractionType().requiresPermissions && (trader = this.menu.getBE().getTrader()) != null && !trader.hasPermission(this.menu.getBE().getReferencedPlayer(), "interactionLink")) {
            list.add((Component)Component.m_237115_((String)"gui.lightmanscurrency.interface.info.trader.permissions").m_130940_(ChatFormatting.RED));
        }
        return list;
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        BankAccount account;
        if (this.menu.getBE() == null) {
            return;
        }
        UniversalTraderData trader = this.menu.getBE().getTrader();
        MutableComponent infoText = null;
        infoText = trader != null ? trader.getTitle() : (this.menu.getBE().hasTrader() ? Component.m_237115_((String)"gui.lightmanscurrency.interface.info.trader.removed").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"gui.lightmanscurrency.interface.info.trader.null"));
        this.font.m_92889_(pose, TextRenderUtil.fitString((Component)infoText, this.screen.getXSize() - 16), (float)(this.screen.getGuiLeft() + 8), (float)(this.screen.getGuiTop() + 6), 0x404040);
        this.tradeDisplay.f_93624_ = this.menu.getBE().getInteractionType().trades;
        this.acceptChangesButton.f_93624_ = this.newTradeDisplay.f_93624_ = this.tradeDisplay.f_93624_ && this.changeInTrades();
        if (this.tradeDisplay.f_93624_ && this.menu.getBE().getReferencedTrade() == null) {
            this.font.m_92889_(pose, (Component)Component.m_237115_((String)"gui.lightmanscurrency.interface.info.trade.notdefined"), (float)(this.screen.getGuiLeft() + 6), (float)(this.screen.getGuiTop() + 20), 0x404040);
        }
        if (this.newTradeDisplay.f_93624_) {
            this.newTradeDisplay.move(this.screen.getGuiLeft() + 6, this.screen.getGuiTop() + 109 - this.newTradeDisplay.m_93694_());
            RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.screen.m_93228_(pose, this.screen.getGuiLeft() - 2 + this.tradeDisplay.m_5711_() / 2, this.screen.getGuiTop() + 54, 206, 18, 16, 22);
            if (this.menu.getBE().getTrueTrade() == null) {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.lightmanscurrency.interface.info.trade.missing").m_130940_(ChatFormatting.RED);
                float f = this.screen.getGuiLeft() + 6;
                int n = this.screen.getGuiTop() + 109;
                Objects.requireNonNull(this.font);
                this.font.m_92889_(pose, (Component)mutableComponent, f, (float)(n - 9), 0x404040);
            }
        }
        if ((account = this.menu.getBE().getBankAccount()) != null && this.menu.getBE().getInteractionType().trades) {
            Component accountName = TextRenderUtil.fitString((Component)account.getName(), 160);
            this.font.m_92889_(pose, accountName, (float)(this.screen.getGuiLeft() + 15 + 88 - this.font.m_92852_((FormattedText)accountName) / 2), (float)(this.screen.getGuiTop() + 120), 0x404040);
            MutableComponent balanceText = Component.m_237110_((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{account.getCoinStorage().getString("0")});
            this.font.m_92889_(pose, (Component)balanceText, (float)(this.screen.getGuiLeft() + 15 + 88 - this.font.m_92852_((FormattedText)balanceText) / 2), (float)(this.screen.getGuiTop() + 130), 0x404040);
        }
    }

    public boolean changeInTrades() {
        TradeData referencedTrade = this.menu.getBE().getReferencedTrade();
        TradeData trueTrade = this.menu.getBE().getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        if (this.menu.getBE() == null) {
            return;
        }
        this.tradeDisplay.renderTooltips(pose, mouseX, mouseY);
        this.newTradeDisplay.renderTooltips(pose, mouseX, mouseY);
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, List.of(this.acceptChangesButton));
    }

    @Override
    public void tick() {
    }

    @Override
    public void onClose() {
    }

    private void onInteractionSelect(int newTypeIndex) {
        TraderInterfaceBlockEntity.InteractionType newType = TraderInterfaceBlockEntity.InteractionType.fromIndex(newTypeIndex);
        ((InfoTab)this.commonTab).changeInteractionType(newType);
    }

    private void AcceptTradeChanges(Button button) {
        ((InfoTab)this.commonTab).acceptTradeChanges();
    }
}

