/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.settings.directional.DirectionalSettings;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemStorageClientTab
extends TraderInterfaceClientTab<ItemStorageTab>
implements ScrollListener.IScrollListener,
ScrollBarWidget.IScrollable {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 8;
    private static final int ROWS = 2;
    private static final int WIDGET_OFFSET = 57;
    DirectionalSettingsWidget inputSettings;
    DirectionalSettingsWidget outputSettings;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public ItemStorageClientTab(TraderInterfaceScreen screen, ItemStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.interface.storage");
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    private DirectionalSettings getInputSettings() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemHandler().getInputSides();
        }
        return new DirectionalSettings();
    }

    private DirectionalSettings getOutputSettings() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemHandler().getOutputSides();
        }
        return new DirectionalSettings();
    }

    @Override
    public void onOpen() {
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 144, this.screen.getGuiTop() + 17, 36, this));
        this.screen.addTabListener(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getXSize(), 118, this));
        this.inputSettings = new DirectionalSettingsWidget(this.screen.getGuiLeft() + 33, this.screen.getGuiTop() + 57 + 9, this::getInputSettings, this::ToggleInputSide, this.screen::addRenderableTabWidget);
        this.outputSettings = new DirectionalSettingsWidget(this.screen.getGuiLeft() + 116, this.screen.getGuiTop() + 57 + 9, this::getOutputSettings, this::ToggleOutputSide, this.screen::addRenderableTabWidget);
        this.screen.addRenderableTabWidget(IconAndButtonUtil.quickInsertButton(this.screen.getGuiLeft() + 22, this.screen.getGuiTop() + 17 + 90 + 8, b -> ((ItemStorageTab)this.commonTab).quickTransfer(0)));
        this.screen.addRenderableTabWidget(IconAndButtonUtil.quickExtractButton(this.screen.getGuiLeft() + 34, this.screen.getGuiTop() + 17 + 90 + 8, b -> ((ItemStorageTab)this.commonTab).quickTransfer(1)));
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.font.m_92889_(pose, (Component)Component.m_237115_((String)"tooltip.lightmanscurrency.interface.storage"), (float)(this.screen.getGuiLeft() + 8), (float)(this.screen.getGuiTop() + 6), 0x404040);
        this.scrollBar.beforeWidgetRender(mouseY);
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            this.validateScroll();
            int index = this.scroll * 8;
            TraderItemStorage storage = ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemBuffer();
            int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY) + this.scroll * 8;
            for (int y = 0; y < 2; ++y) {
                int n = this.screen.getGuiTop() + 17 + y * 18;
                for (int x = 0; x < 8; ++x) {
                    int xPos = this.screen.getGuiLeft() + 13 + x * 18;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.screen.m_93228_(pose, xPos, n, 206, 0, 18, 18);
                    if (index < storage.getSlotCount()) {
                        ItemRenderUtil.drawItemStack((GuiComponent)this.screen, this.font, storage.getContents().get(index), xPos + 1, n + 1, this.getCountText(storage.getContents().get(index)));
                    }
                    if (index == hoveredSlot) {
                        AbstractContainerScreen.m_169606_((PoseStack)pose, (int)(xPos + 1), (int)(n + 1), (int)this.screen.m_93252_());
                    }
                    ++index;
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (Slot slot : ((ItemStorageTab)this.commonTab).getSlots()) {
                this.screen.m_93228_(pose, this.screen.getGuiLeft() + slot.f_40220_ - 1, this.screen.getGuiTop() + slot.f_40221_ - 1, 206, 0, 18, 18);
            }
            this.font.m_92889_(pose, (Component)Component.m_237115_((String)"gui.lightmanscurrency.settings.iteminput.side"), (float)(this.screen.getGuiLeft() + 33), (float)(this.screen.getGuiTop() + 57), 0x404040);
            int textWidth = this.font.m_92852_((FormattedText)Component.m_237115_((String)"gui.lightmanscurrency.settings.itemoutput.side"));
            this.font.m_92889_(pose, (Component)Component.m_237115_((String)"gui.lightmanscurrency.settings.itemoutput.side"), (float)(this.screen.getGuiLeft() + 173 - textWidth), (float)(this.screen.getGuiTop() + 57), 0x404040);
        }
    }

    private String getCountText(ItemStack stack) {
        int count = stack.m_41613_();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + String.valueOf(count % 1000 / 100);
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            TraderItemStorage storage;
            int hoveredSlot;
            if (((TraderInterfaceMenu)this.screen.m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0 && (hoveredSlot += this.scroll * 8) < (storage = ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemBuffer()).getContents().size()) {
                ItemStack stack = storage.getContents().get(hoveredSlot);
                List<Component> tooltip = ItemRenderUtil.getTooltipFromItem(stack);
                tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.itemstorage", (Object[])new Object[]{stack.m_41613_()}));
                if (stack.m_41613_() >= 64) {
                    if (stack.m_41613_() % 64 == 0) {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.itemstorage.stacks.single", (Object[])new Object[]{stack.m_41613_() / 64}));
                    } else {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.itemstorage.stacks.multi", (Object[])new Object[]{stack.m_41613_() / 64, stack.m_41613_() % 64}));
                    }
                }
                this.screen.m_96597_(pose, tooltip, mouseX, mouseY);
            }
            this.inputSettings.renderTooltips(pose, mouseX, mouseY, (Screen)this.screen);
            this.outputSettings.renderTooltips(pose, mouseX, mouseY, (Screen)this.screen);
        }
    }

    @Override
    public void tick() {
        this.inputSettings.tick();
        this.outputSettings.tick();
    }

    private void validateScroll() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 8 && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(leftEdge + x * 18)) || !(mouseX < (double)(leftEdge + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 2 && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(topEdge + y * 18)) || !(mouseY < (double)(topEdge + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 8 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemBuffer().getContents().size();
        }
        return 0;
    }

    private boolean canScrollDown() {
        return this.totalStorageSlots() - this.scroll * 8 > 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0) {
            ((ItemStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 8, Screen.m_96638_(), button == 0);
            return true;
        }
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 8 - 2 + 1, 0);
    }

    private void ToggleInputSide(Direction side) {
        ((ItemStorageTab)this.commonTab).toggleInputSlot(side);
    }

    private void ToggleOutputSide(Direction side) {
        ((ItemStorageTab)this.commonTab).toggleOutputSlot(side);
    }
}

