/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.item;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemInputTab
extends SettingsTab {
    public static final ItemInputTab INSTANCE = new ItemInputTab();
    DirectionalSettingsWidget inputWidget;
    DirectionalSettingsWidget outputWidget;
    private final int textColor = 0xD0D0D0;

    private ItemInputTab() {
    }

    @Override
    public int getColor() {
        return 48896;
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42155_);
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.settings.iteminput");
    }

    @Override
    public boolean canOpen() {
        return this.hasPermissions("changeExternalInputs");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.inputWidget = new DirectionalSettingsWidget(screen.guiLeft() + 20, screen.guiTop() + 25, () -> this.getSetting(ItemTraderSettings.class).getInputSides(), this::ToggleInputSide, screen::addRenderableTabWidget);
        this.outputWidget = new DirectionalSettingsWidget(screen.guiLeft() + 110, screen.guiTop() + 25, () -> this.getSetting(ItemTraderSettings.class).getOutputSides(), this::ToggleOutputSide, screen::addRenderableTabWidget);
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        this.getFont().m_92889_(pose, (Component)Component.m_237115_((String)"gui.lightmanscurrency.settings.iteminput.side"), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 7), 0xD0D0D0);
        this.getFont().m_92889_(pose, (Component)Component.m_237115_((String)"gui.lightmanscurrency.settings.itemoutput.side"), (float)(screen.guiLeft() + 110), (float)(screen.guiTop() + 7), 0xD0D0D0);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.inputWidget.renderTooltips(pose, mouseX, mouseY, this.getScreen());
        this.outputWidget.renderTooltips(pose, mouseX, mouseY, this.getScreen());
    }

    @Override
    public void tick() {
        this.inputWidget.tick();
        this.outputWidget.tick();
    }

    @Override
    public void closeTab() {
    }

    private void ToggleInputSide(Direction side) {
        LightmansCurrency.LogInfo("Toggling input side " + side.toString());
        ItemTraderSettings settings = this.getSetting(ItemTraderSettings.class);
        CompoundTag updateInfo = settings.toggleInputSide(this.getPlayer(), side);
        settings.sendToServer(updateInfo);
    }

    private void ToggleOutputSide(Direction side) {
        LightmansCurrency.LogInfo("Toggling output side " + side.toString());
        ItemTraderSettings settings = this.getSetting(ItemTraderSettings.class);
        CompoundTag updateInfo = settings.toggleOutputSide(this.getPlayer(), side);
        settings.sendToServer(updateInfo);
    }
}

