/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageCreateTeamBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageSetTeamBankLimit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class TeamBankAccountTab
extends TeamTab {
    public static final TeamBankAccountTab INSTANCE = new TeamBankAccountTab();
    Button buttonCreateBankAccount;
    Button buttonToggleAccountLimit;
    ScrollTextDisplay logWidget;

    private TeamBankAccountTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of(ModBlocks.COINPILE_GOLD);
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.team.bank");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.buttonCreateBankAccount = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.team.bank.create"), this::createBankAccount));
        this.buttonToggleAccountLimit = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 60, 160, 20, (Component)Component.m_237119_(), this::toggleBankLimit));
        this.updateBankLimitText();
        this.logWidget = screen.addRenderableTabWidget(new ScrollTextDisplay(screen.guiLeft() + 20, screen.guiTop() + 90, 160, 100, screen.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getAccountLog)));
        this.logWidget.invertText = true;
        this.logWidget.f_93624_ = screen.getActiveTeam().hasBankAccount();
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.getActiveTeam() == null) {
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        if (this.getActiveTeam() != null && this.getActiveTeam().hasBankAccount()) {
            this.getFont().m_92889_(pose, (Component)Component.m_237110_((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{this.getActiveTeam().getBankAccount().getCoinStorage().getString("0")}), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 46), 0x404040);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam() == null) {
            return;
        }
        this.buttonCreateBankAccount.f_93623_ = !this.getActiveTeam().hasBankAccount();
        this.logWidget.f_93624_ = this.getScreen().getActiveTeam().hasBankAccount();
    }

    private List<MutableComponent> getAccountLog() {
        if (this.getActiveTeam() == null || this.getActiveTeam().getBankAccount() == null) {
            return new ArrayList<MutableComponent>();
        }
        return this.getActiveTeam().getBankAccount().getLogs().logText;
    }

    @Override
    public void closeTab() {
    }

    private void createBankAccount(Button button) {
        if (this.getActiveTeam() == null || !this.getActiveTeam().isOwner(this.getPlayer())) {
            return;
        }
        this.getActiveTeam().createBankAccount(this.getPlayer());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCreateTeamBankAccount(this.getActiveTeam().getID()));
    }

    private void toggleBankLimit(Button button) {
        if (this.getActiveTeam() == null || !this.getActiveTeam().isOwner(this.getPlayer())) {
            return;
        }
        int newLimit = Team.NextBankLimit(this.getActiveTeam().getBankLimit());
        this.getActiveTeam().changeBankLimit(this.getPlayer(), newLimit);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTeamBankLimit(this.getActiveTeam().getID(), newLimit));
        this.updateBankLimitText();
    }

    private void updateBankLimitText() {
        MutableComponent message = Component.m_237110_((String)"gui.button.lightmanscurrency.team.bank.limit", (Object[])new Object[]{Component.m_237115_((String)("gui.button.lightmanscurrency.team.bank.limit." + this.getActiveTeam().getBankLimit()))});
        this.buttonToggleAccountLimit.m_93666_((Component)message);
    }
}

