/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamMemberListTab
extends TeamTab {
    public static final TeamMemberListTab INSTANCE = new TeamMemberListTab();
    ScrollTextDisplay memberDisplay;

    private TeamMemberListTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.team.members");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        int n = screen.guiLeft() + 10;
        int n2 = screen.guiTop() + 10;
        Objects.requireNonNull(screen);
        Objects.requireNonNull(screen);
        this.memberDisplay = screen.addRenderableTabWidget(new ScrollTextDisplay(n, n2, 200 - 20, 200 - 20, this.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<Component> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            list.add(team.getOwner().lastKnownNameComponent().m_130940_(ChatFormatting.GREEN));
            team.getAdmins().forEach(admin -> list.add(admin.lastKnownNameComponent().m_130940_(ChatFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(member.lastKnownNameComponent()));
        }
        return list;
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
    }

    @Override
    public void closeTab() {
    }
}

