/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageRenameTeam;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class TeamNameTab
extends TeamTab {
    public static final TeamNameTab INSTANCE = new TeamNameTab();
    EditBox nameInput;
    Button buttonChangeName;

    private TeamNameTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((Component)Component.m_237115_((String)"gui.button.lightmanscurrency.changename"));
    }

    @Override
    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.team.name");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null && team.isAdmin(player);
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.nameInput = screen.addRenderableTabWidget(new EditBox(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (Component)Component.m_237119_()));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(this.getActiveTeam().getName());
        this.buttonChangeName = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 45, 160, 20, (Component)Component.m_237115_((String)"gui.button.lightmanscurrency.team.rename"), this::changeName));
        this.buttonChangeName.f_93623_ = false;
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        TeamManagerScreen screen = this.getScreen();
        String currentName = "NULL";
        if (this.getActiveTeam() != null) {
            currentName = this.getActiveTeam().getName();
        }
        this.getFont().m_92889_(pose, (Component)Component.m_237110_((String)"gui.lightmanscurrency.team.name.current", (Object[])new Object[]{currentName}), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        this.nameInput.m_94120_();
        this.buttonChangeName.f_93623_ = !this.nameInput.m_94155_().isBlank() && !this.nameInput.m_94155_().contentEquals(this.getActiveTeam().getName());
    }

    @Override
    public void closeTab() {
    }

    private void changeName(Button button) {
        if (this.nameInput.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        this.getActiveTeam().changeName(this.getPlayer(), this.nameInput.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRenameTeam(this.getActiveTeam().getID(), this.nameInput.m_94155_()));
    }
}

