/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ScrollTextDisplay
extends AbstractWidget {
    private Font font;
    private final Supplier<List<? extends Component>> textSource;
    public boolean invertText = false;
    public int backgroundColor = -16777216;
    public int textColor = 0xFFFFFF;
    private int columnCount = 1;
    private int scroll = 0;

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = MathUtil.clamp(columnCount, 1, Integer.MAX_VALUE);
    }

    public ScrollTextDisplay(int x, int y, int width, int height, Font font, Supplier<List<? extends Component>> textSource) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.font = font;
        this.textSource = textSource;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        int rowHeight;
        if (!this.f_93624_) {
            return;
        }
        Screen.m_93172_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.backgroundColor);
        List text = (List)this.textSource.get();
        this.validateScroll(text.size());
        int i = this.getStartingIndex(text.size());
        int columnWidth = this.getColumnWidth();
        int bottom = this.f_93621_ + this.f_93619_;
        for (int yPos = this.f_93621_ + 2; yPos < bottom && i >= 0 && i < text.size(); yPos += rowHeight) {
            rowHeight = 0;
            for (int col = 0; col < this.columnCount && i >= 0 && i < text.size(); ++col) {
                int xPos = this.getXPos(col);
                Component thisText = (Component)text.get(i);
                int thisHeight = this.font.m_92920_(thisText.getString(), columnWidth);
                if (yPos + thisHeight < bottom) {
                    this.font.m_92857_((FormattedText)thisText, xPos, yPos, columnWidth, this.textColor);
                }
                if (thisHeight > rowHeight) {
                    rowHeight = thisHeight;
                }
                i = this.invertText ? i - 1 : i + 1;
            }
        }
    }

    private void validateScroll(int listSize) {
        if (this.scroll * this.columnCount >= listSize) {
            this.scroll = MathUtil.clamp(this.scroll, 0, listSize / this.columnCount - 1);
        }
    }

    private int getStartingIndex(int listSize) {
        return this.invertText ? listSize - 1 - this.scroll * this.columnCount : this.scroll * this.columnCount;
    }

    private int getColumnWidth() {
        return (this.f_93618_ - 4) / this.columnCount;
    }

    private int getXPos(int column) {
        int columnSpacing = this.f_93618_ / this.columnCount;
        return this.f_93620_ + 2 + column * columnSpacing;
    }

    private boolean canScrollDown() {
        return this.scroll < ((List)this.textSource.get()).size();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }
}

