/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.player.CPacketRequestPlayerList;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlayerSuggestionsUtil {
    private static Timer timer = new Timer();
    public static final long PLAYER_LIST_REQUEST_DELAY = 300000L;

    public static List<String> getSuggestions(String search) {
        return PlayerSuggestionsUtil.getSuggestions(search, new ArrayList<PlayerReference>());
    }

    public static List<String> getSuggestions(String search, List<PlayerReference> ignoreEntries) {
        return PlayerSuggestionsUtil.getSuggestions(search, PlayerReference.getKnownPlayers(), ignoreEntries);
    }

    public static List<String> getSuggestions(String search, List<PlayerReference> options, List<PlayerReference> ignoreEntries) {
        Objects.requireNonNull(search);
        Objects.requireNonNull(options);
        Objects.requireNonNull(ignoreEntries);
        ArrayList<String> suggestions = new ArrayList<String>();
        if (search.isBlank()) {
            return suggestions;
        }
        for (PlayerReference player : options) {
            if (!player.lastKnownName().toLowerCase().startsWith(search.toLowerCase()) || !ignoreEntries.stream().noneMatch(ignored -> player.is((PlayerReference)ignored))) continue;
            suggestions.add(player.lastKnownName());
        }
        return suggestions;
    }

    public static void loadFromServerData(CompoundTag serverData) {
        if (serverData.m_128425_("KnownPlayers", 9)) {
            PlayerReference.clearPlayerCache();
            ListTag knownPlayerList = serverData.m_128437_("KnownPlayers", 10);
            for (int i = 0; i < knownPlayerList.size(); ++i) {
                PlayerReference.load(knownPlayerList.m_128728_(i));
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        try {
            timer = new Timer();
            RequestPlayerListTask task = new RequestPlayerListTask();
            timer.scheduleAtFixedRate((TimerTask)task, 300000L, 300000L);
            ((TimerTask)task).run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        try {
            timer.cancel();
            timer = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class RequestPlayerListTask
    extends TimerTask {
        private RequestPlayerListTask() {
        }

        @Override
        public void run() {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketRequestPlayerList());
        }
    }
}

