/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandLCAdmin {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcadmin").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"help").executes(CommandLCAdmin::help))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggleadmin").requires(commandSource -> commandSource.m_81373_() instanceof ServerPlayer)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"universaldata").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listUniversalData))).then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"searchText", (ArgumentType)MessageArgument.m_96832_()).executes(CommandLCAdmin::searchUniversalData)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"dataID", (ArgumentType)MessageArgument.m_96832_()).executes(CommandLCAdmin::deleteUniversalData))));
        dispatcher.register(lcAdminCommand);
    }

    static int help(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.help.help", (Object[])new Object[]{"/lcadmin help -> "}), false);
        if (source.m_81373_() instanceof ServerPlayer) {
            source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.toggleadmin.help", (Object[])new Object[]{"/lcadmin toggleadmin -> "}), false);
        }
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.help", (Object[])new Object[]{"/lcadmin universaldata list -> "}), false);
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.help", (Object[])new Object[]{"/lcadmin universaldata search <searchText> -> "}), false);
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.delete.help", (Object[])new Object[]{"/lcadmin universaldata delete <dataID> "}), false);
        return 1;
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.m_81375_();
        TradingOffice.toggleAdminPlayer((Player)sourcePlayer);
        MutableComponent enabledDisabled = TradingOffice.isAdminPlayer((Player)sourcePlayer) ? Component.m_237115_((String)"command.lightmanscurrency.lcadmin.toggleadmin.enabled").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"command.lightmanscurrency.lcadmin.toggleadmin.disabled").m_130940_(ChatFormatting.RED);
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.toggleadmin", (Object[])new Object[]{enabledDisabled}), true);
        return 1;
    }

    static int listUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        if (allTraders.size() > 0) {
            source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.m_81354_((Component)Component.m_237119_(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.none"), true);
        }
        return 1;
    }

    static int searchUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String searchText = MessageArgument.m_96835_(commandContext, (String)"searchText").getString();
        List<UniversalTraderData> allTraders = TradingOffice.getTraders(searchText);
        if (allTraders.size() > 0) {
            source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                UniversalTraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.m_81354_((Component)Component.m_237119_(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.search.none"), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(UniversalTraderData thisTrader, CommandSourceStack source) {
        String traderID = thisTrader.getTraderID().toString();
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.traderid", (Object[])new Object[]{Component.m_237113_((String)traderID).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip"))))}), true);
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.type", (Object[])new Object[]{thisTrader.getTraderType()}), true);
        if (thisTrader.getCoreSettings().getTeam() != null) {
            source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner.team", (Object[])new Object[]{thisTrader.getCoreSettings().getTeam().getName(), thisTrader.getCoreSettings().getTeam().getID().toString()}), true);
        } else if (thisTrader.getCoreSettings().getOwner() != null) {
            source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner", (Object[])new Object[]{thisTrader.getCoreSettings().getOwner().lastKnownName(), thisTrader.getCoreSettings().getOwner().id.toString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner.none"), true);
        }
        String dimension = thisTrader.getWorld().m_135782_().toString();
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.dimension", (Object[])new Object[]{dimension}), true);
        BlockPos pos = thisTrader.getPos();
        String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
        String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
        source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.position", (Object[])new Object[]{Component.m_237113_((String)position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip"))))}), true);
        if (thisTrader.getCoreSettings().hasCustomName()) {
            source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.list.name", (Object[])new Object[]{thisTrader.getName()}), true);
        }
    }

    static int deleteUniversalData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String traderID = MessageArgument.m_96835_(commandContext, (String)"dataID").getString();
        if (traderID == "") {
            source.m_81352_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.delete.noid"));
            return 0;
        }
        List<UniversalTraderData> allTraders = TradingOffice.getTraders();
        for (int i = 0; i < allTraders.size(); ++i) {
            if (!allTraders.get(i).getTraderID().toString().equals(traderID)) continue;
            TradingOffice.removeTrader(allTraders.get(i).getTraderID());
            source.m_81354_((Component)Component.m_237110_((String)"command.lightmanscurrency.lcadmin.universaldata.delete.success", (Object[])new Object[]{traderID}), true);
            return 1;
        }
        source.m_81354_((Component)Component.m_237115_((String)"command.lightmanscurrency.lcadmin.universaldata.delete.notfound"), true);
        return 0;
    }
}

