/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class Notification {
    private static final Map<String, Function<CompoundTag, Notification>> DESERIALIZERS = new HashMap<String, Function<CompoundTag, Notification>>();
    private boolean seen = false;
    private int count = 1;

    public static final void register(ResourceLocation type, Function<CompoundTag, Notification> deserializer) {
        String t = type.toString();
        if (DESERIALIZERS.containsKey(t)) {
            LightmansCurrency.LogError("Notification of type " + t + " is already registered.");
            return;
        }
        if (deserializer == null) {
            LightmansCurrency.LogError("Deserializer of notification type " + t + " is null. Unable to register.");
            return;
        }
        DESERIALIZERS.put(t, deserializer);
    }

    public static final Notification deserialize(CompoundTag compound) {
        if (compound.m_128441_("type")) {
            String type = compound.m_128461_("type");
            if (DESERIALIZERS.containsKey(type)) {
                return DESERIALIZERS.get(type).apply(compound);
            }
            LightmansCurrency.LogError("Cannot deserialize notification type " + type + " as no deserializer has been registered.");
            return null;
        }
        LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag.");
        return null;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected abstract ResourceLocation getType();

    public abstract Category getCategory();

    public abstract MutableComponent getMessage();

    public MutableComponent getGeneralMessage() {
        return Component.m_237110_((String)"notifications.source.general.format", (Object[])new Object[]{this.getCategory().getTooltip(), this.getMessage()});
    }

    public MutableComponent getChatMessage() {
        return Component.m_237110_((String)"notifications.chat.format", (Object[])new Object[]{Component.m_237110_((String)"notifications.chat.format.title", (Object[])new Object[]{this.getCategory().getTooltip()}).m_130940_(ChatFormatting.GOLD), this.getMessage()});
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.seen) {
            compound.m_128379_("Seen", true);
        }
        compound.m_128405_("Count", this.count);
        compound.m_128359_("type", this.getType().toString());
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void load(CompoundTag compound) {
        if (compound.m_128441_("Seen")) {
            this.seen = true;
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(CompoundTag var1);

    public boolean onNewNotification(Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(Notification var1);

    public static abstract class Category
    implements TabButton.ITab {
        public static final ResourceLocation GENERAL_TYPE = new ResourceLocation("lightmanscurrency", "general");
        private static final Map<String, Function<CompoundTag, Category>> DESERIALIZERS = new HashMap<String, Function<CompoundTag, Category>>();
        public static final Category GENERAL = new Category(){

            @Override
            public IconData getIcon() {
                return IconData.of((ItemLike)Items.f_42009_);
            }

            @Override
            public MutableComponent getName() {
                return Component.m_237115_((String)"notifications.source.general");
            }

            @Override
            public boolean matches(Category other) {
                return other == GENERAL;
            }

            @Override
            protected ResourceLocation getType() {
                return GENERAL_TYPE;
            }

            @Override
            protected void saveAdditional(CompoundTag compound) {
            }
        };

        public static final void register(ResourceLocation type, Function<CompoundTag, Category> deserializer) {
            String t = type.toString();
            if (DESERIALIZERS.containsKey(t)) {
                LightmansCurrency.LogError("Category of type " + t + " is already registered.");
                return;
            }
            if (deserializer == null) {
                LightmansCurrency.LogError("Deserializer of category type " + t + " is null. Unable to register.");
                return;
            }
            DESERIALIZERS.put(t, deserializer);
        }

        public static final Category deserialize(CompoundTag compound) {
            if (compound.m_128441_("type")) {
                String type = compound.m_128461_("type");
                if (DESERIALIZERS.containsKey(type)) {
                    return DESERIALIZERS.get(type).apply(compound);
                }
                LightmansCurrency.LogError("Cannot deserialize notification type " + type + " as no deserializer has been registered.");
                return null;
            }
            LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag.");
            return null;
        }

        @Override
        public final MutableComponent getTooltip() {
            return this.getName();
        }

        public abstract MutableComponent getName();

        @Override
        public final int getColor() {
            return 0xFFFFFF;
        }

        protected abstract ResourceLocation getType();

        public abstract boolean matches(Category var1);

        public final CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("type", this.getType().toString());
            this.saveAdditional(compound);
            return compound;
        }

        protected abstract void saveAdditional(CompoundTag var1);
    }
}

