/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class OutOfStockNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "out_of_stock");
    TraderCategory traderData;
    int tradeSlot;

    public OutOfStockNotification(TraderCategory traderData, int tradeIndex) {
        this.traderData = traderData;
        this.tradeSlot = tradeIndex + 1;
    }

    public OutOfStockNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Notification.Category getCategory() {
        return this.traderData;
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"notifications.message.out_of_stock", (Object[])new Object[]{this.traderData.getTooltip(), this.tradeSlot});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeSlot", this.tradeSlot);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeSlot = compound.m_128451_("TradeSlot");
    }

    @Override
    protected boolean canMerge(Notification other) {
        return false;
    }
}

