/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PaygateNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "paygate_trade");
    TraderCategory traderData;
    UUID ticketID = null;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    int duration = 0;
    String customer;

    public PaygateNotification(PaygateTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        this.traderData = traderData;
        this.ticketID = trade.getTicketID();
        if (trade.isTicketTrade()) {
            this.ticketID = trade.getTicketID();
        } else {
            this.cost = cost;
        }
        this.duration = trade.getDuration();
        this.customer = customer.lastKnownName();
    }

    public PaygateNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Notification.Category getCategory() {
        return this.traderData;
    }

    @Override
    public MutableComponent getMessage() {
        if (this.ticketID != null) {
            return Component.m_237110_((String)"notifications.message.paygate_trade.ticket", (Object[])new Object[]{this.customer, this.ticketID.toString(), PaygateTradeData.formatDurationShort(this.duration)});
        }
        return Component.m_237110_((String)"notifications.message.paygate_trade.coin", (Object[])new Object[]{this.customer, this.cost.getString(), PaygateTradeData.formatDurationShort(this.duration)});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("Duration", this.duration);
        if (this.ticketID != null) {
            compound.m_128362_("Ticket", this.ticketID);
        } else {
            this.cost.writeToNBT(compound, "Price");
        }
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.duration = compound.m_128451_("Duration");
        if (compound.m_128441_("Ticket")) {
            this.ticketID = compound.m_128342_("Ticket");
        } else if (compound.m_128441_("Price")) {
            this.cost.readFromNBT(compound, "Price");
        }
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof PaygateNotification) {
            PaygateNotification pn = (PaygateNotification)other;
            if (!pn.traderData.matches(this.traderData)) {
                return false;
            }
            if (pn.ticketID == null != (this.ticketID == null)) {
                return false;
            }
            if (pn.ticketID != null && !pn.ticketID.equals(this.ticketID)) {
                return false;
            }
            if (pn.duration != this.duration) {
                return false;
            }
            if (pn.cost.getRawValue() != this.cost.getRawValue()) {
                return false;
            }
            return pn.customer.equals(this.customer);
        }
        return false;
    }
}

