/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.common.notifications.types.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AuctionHouseBuyerNotification
extends AuctionHouseNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "auction_house_buyer");
    List<ItemTradeNotification.ItemData> items;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);

    public AuctionHouseBuyerNotification(AuctionTradeData trade) {
        this.cost = trade.getLastBidAmount().copy();
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemTradeNotification.ItemData(trade.getAuctionItems().get(i)));
        }
    }

    public AuctionHouseBuyerNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public MutableComponent getMessage() {
        Component itemText = this.getItemNames(this.items);
        MutableComponent cost = this.cost.getComponent("0");
        return Component.m_237110_((String)"notifications.message.auction.buyer", (Object[])new Object[]{itemText, cost});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag itemList = new ListTag();
        for (ItemTradeNotification.ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        this.cost.writeToNBT(compound, "Price");
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemTradeNotification.ItemData(itemList.m_128728_(i)));
        }
        this.cost.readFromNBT(compound, "Price");
    }
}

