/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.auction;

import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class AuctionPlayerStorage {
    PlayerReference owner;
    List<AuctionTradeData> expiredTrades = new ArrayList<AuctionTradeData>();
    CoinValue storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
    List<ItemStack> storedItems = new ArrayList<ItemStack>();

    public PlayerReference getOwner() {
        return this.owner;
    }

    public CoinValue getStoredCoins() {
        return this.storedCoins;
    }

    public List<ItemStack> getStoredItems() {
        return this.storedItems;
    }

    public AuctionPlayerStorage(PlayerReference player) {
        this.owner = player;
    }

    public AuctionPlayerStorage(CompoundTag compound) {
        this.load(compound);
    }

    public CompoundTag save(CompoundTag compound) {
        compound.m_128365_("Owner", (Tag)this.owner.save());
        this.storedCoins.writeToNBT(compound, "StoredMoney");
        ListTag itemList = new ListTag();
        for (int i = 0; i < this.storedItems.size(); ++i) {
            itemList.add((Object)this.storedItems.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128365_("StoredItems", (Tag)itemList);
        return compound;
    }

    protected void load(CompoundTag compound) {
        this.owner = PlayerReference.load(compound.m_128469_("Owner"));
        this.storedCoins.readFromNBT(compound, "StoredMoney");
        this.storedItems.clear();
        ListTag itemList = compound.m_128437_("StoredItems", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.storedItems.add(stack);
        }
    }

    public void giveMoney(CoinValue amount) {
        this.storedCoins.addValue(amount);
    }

    public CoinValue takeMoney(CoinValue amount) {
        long newValue = this.storedCoins.getRawValue() - amount.getRawValue();
        if (newValue < 0L) {
            this.storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
            return new CoinValue(-newValue);
        }
        this.storedCoins.readFromOldValue(newValue);
        return new CoinValue(new CoinValue.CoinValuePair[0]);
    }

    public void collectedMoney(Player player) {
        MoneyUtil.ProcessChange(null, player, this.storedCoins.copy());
        this.storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
    }

    public void giveItem(ItemStack item) {
        if (!item.m_41619_()) {
            this.storedItems.add(item);
        }
    }

    public void removePartial(int itemSlot, int count) {
        if (this.storedItems.size() >= itemSlot || itemSlot < 0) {
            return;
        }
        this.storedItems.get(itemSlot).m_41774_(count);
        if (this.storedItems.get(itemSlot).m_41619_()) {
            this.storedItems.remove(itemSlot);
        }
    }

    public void collectItems(Player player) {
        for (ItemStack stack : this.storedItems) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        this.storedItems = new ArrayList<ItemStack>();
    }
}

