/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.logger.MessageClearUniversalLogger;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageChangeSettings2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenTrades2;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public abstract class UniversalTraderData
implements ITrader {
    public static final ResourceLocation ICON_RESOURCE = new ResourceLocation("lightmanscurrency", "textures/gui/universal_trader_icons.png");
    CoreTraderSettings coreSettings = new CoreTraderSettings(this, this::markCoreSettingsDirty, this::sendSettingsUpdateToServer);
    UUID traderID = null;
    BlockPos pos = new BlockPos(0, 0, 0);
    ResourceKey<Level> world = Level.f_46428_;
    CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private boolean isServer = true;

    public UUID getTraderID() {
        return this.traderID;
    }

    public void initTraderID(UUID traderID) {
        if (this.traderID == null) {
            this.traderID = traderID;
        } else {
            LightmansCurrency.LogWarning("Attempted to set the traders ID when it's already been defined.");
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    @Override
    public CoinValue getStoredMoney() {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            return account.getCoinStorage().copy();
        }
        return this.storedMoney;
    }

    @Override
    public CoinValue getInternalStoredMoney() {
        return this.storedMoney;
    }

    @Override
    public final boolean isServer() {
        return this.isServer;
    }

    @Override
    public final boolean isClient() {
        return !this.isServer;
    }

    public final UniversalTraderData flagAsClient() {
        this.isServer = false;
        return this;
    }

    public boolean hasValidTrade() {
        return !this.hasNoValidTrades();
    }

    public boolean hasNoValidTrades() {
        for (TradeButton.ITradeData iTradeData : this.getTradeInfo()) {
            if (!iTradeData.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TraderCategory getNotificationCategory() {
        ItemLike icon = (ItemLike)ModItems.TRADING_CORE.get();
        try {
            icon = this.getCategoryItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TraderCategory(icon, this.getName());
    }

    protected abstract ItemLike getCategoryItem();

    @Deprecated
    public final void markDirty() {
        if (this.isServer) {
            TradingOffice.MarkDirty(this.traderID);
        }
    }

    public final void markDirty(CompoundTag compound) {
        if (this.isServer) {
            this.writeCoreData(compound);
            TradingOffice.MarkDirty(this.traderID, compound);
        }
    }

    public final void markDirty(Function<CompoundTag, CompoundTag> writer) {
        if (this.isServer) {
            this.markDirty((CompoundTag)writer.apply((Object)new CompoundTag()));
        }
    }

    @Override
    public CoreTraderSettings getCoreSettings() {
        return this.coreSettings;
    }

    @Override
    public void markCoreSettingsDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeCoreSettings));
    }

    protected final void sendSettingsUpdateToServer(ResourceLocation type, CompoundTag updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageChangeSettings2(this.traderID, type, updateInfo));
        }
    }

    public final void changeSettings(ResourceLocation type, Player requestor, CompoundTag updateInfo) {
        if (this.isClient()) {
            LightmansCurrency.LogError("UniversalTraderData.changeSettings was called on a client.");
        }
        if (type.equals((Object)this.coreSettings.getType())) {
            this.coreSettings.changeSetting(requestor, updateInfo);
        } else {
            this.getAdditionalSettings().forEach(setting -> {
                if (type.equals((Object)setting.getType())) {
                    setting.changeSetting(requestor, updateInfo);
                }
            });
        }
    }

    @Override
    public void addStoredMoney(CoinValue addedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.depositCoins(addedAmount);
            account.LogInteraction(this, addedAmount, true);
            return;
        }
        this.storedMoney.addValue(addedAmount);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    @Override
    public void removeStoredMoney(CoinValue removedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.withdrawCoins(removedAmount);
            account.LogInteraction(this, removedAmount, false);
            return;
        }
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    @Override
    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    @Override
    public void markMoneyDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStoredMoney));
    }

    public UniversalTraderData() {
    }

    public UniversalTraderData(PlayerReference owner, BlockPos pos, ResourceKey<Level> world, UUID traderID) {
        this.coreSettings.initializeOwner(owner);
        this.pos = pos;
        this.traderID = traderID;
        this.world = world;
    }

    public void read(CompoundTag compound) {
        this.read(compound, true);
    }

    private void read(CompoundTag compound, boolean checkVersion) {
        if (compound.m_128441_("ID")) {
            this.traderID = compound.m_128342_("ID");
        }
        if (compound.m_128425_("CoreSettings", 10)) {
            this.coreSettings.load(compound.m_128469_("CoreSettings"));
        } else {
            this.coreSettings.loadFromOldUniversalData(compound);
        }
        if (compound.m_128441_("x") && compound.m_128441_("y") && compound.m_128441_("z")) {
            this.pos = new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
        }
        if (compound.m_128441_("World")) {
            this.world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("World")));
        }
        if (compound.m_128441_("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (checkVersion) {
            this.readVersion(compound);
        }
    }

    public CompoundTag write(CompoundTag compound) {
        this.writeCoreData(compound);
        this.writeCoreSettings(compound);
        this.writeStoredMoney(compound);
        this.writeWorldData(compound);
        this.writeVersion(compound);
        return compound;
    }

    protected final CompoundTag writeCoreData(CompoundTag compound) {
        if (this.traderID != null) {
            compound.m_128362_("ID", this.traderID);
        }
        compound.m_128359_("type", this.getTraderType().toString());
        return compound;
    }

    protected final CompoundTag writeCoreSettings(CompoundTag compound) {
        compound.m_128365_("CoreSettings", (Tag)this.coreSettings.save(new CompoundTag()));
        return compound;
    }

    protected final CompoundTag writeWorldData(CompoundTag compound) {
        if (this.pos != null) {
            compound.m_128405_("x", this.pos.m_123341_());
            compound.m_128405_("y", this.pos.m_123342_());
            compound.m_128405_("z", this.pos.m_123343_());
        }
        if (this.world != null) {
            compound.m_128359_("World", this.world.m_135782_().toString());
        }
        return compound;
    }

    protected final CompoundTag writeStoredMoney(CompoundTag compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected final CompoundTag writeVersion(CompoundTag compound) {
        compound.m_128405_("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    protected final void readVersion(CompoundTag compound) {
        int oldVersion;
        if (compound.m_128425_("TraderVersion", 3) && (oldVersion = compound.m_128451_("TraderVersion")) < this.GetCurrentVersion()) {
            this.onVersionUpdate(oldVersion);
        }
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public abstract ResourceLocation getTraderType();

    protected MenuProvider getTradeMenuProvider() {
        return new TradeMenuProvider(this.traderID);
    }

    @Override
    public void openTradeMenu(Player playerEntity) {
        MenuProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (playerEntity instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    protected MenuProvider getStorageMenuProvider() {
        return new StorageMenuProvider(this.traderID);
    }

    @Override
    public void openStorageMenu(Player player) {
        if (!this.hasPermission(player, "openStorage")) {
            Settings.PermissionWarning(player, "open trader storage", "openStorage");
            return;
        }
        MenuProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    @Override
    public MutableComponent getDefaultName() {
        return Component.m_237115_((String)"gui.lightmanscurrency.universaltrader.default");
    }

    public static boolean equals(UniversalTraderData data1, UniversalTraderData data2) {
        return data1.write(new CompoundTag()).equals((Object)data2.write(new CompoundTag()));
    }

    public abstract IconData getIcon();

    @Override
    public void sendOpenTraderMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades2(this.traderID));
        }
    }

    @Override
    public void sendOpenStorageMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(this.traderID));
        }
    }

    @Override
    public void sendClearLogMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageClearUniversalLogger(this.traderID));
        }
    }

    public abstract CompoundTag getPersistentData();

    public abstract void loadPersistentData(CompoundTag var1);

    public void loadFromJson(JsonObject json) throws Exception {
        if (json.has("TraderName")) {
            this.coreSettings.forceCustomName(json.get("TraderName").getAsString());
        }
        if (json.has("OwnerName")) {
            this.coreSettings.setCustomOwnerName(json.get("OwnerName").getAsString());
        }
    }

    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("type", this.getTraderType().toString());
        if (this.coreSettings.hasCustomName()) {
            json.addProperty("TraderName", this.coreSettings.getCustomName());
        }
        return json;
    }

    public void onRemoved() {
    }

    public boolean shouldRemove(MinecraftServer server) {
        try {
            BlockPos pos = this.pos;
            ServerLevel world = server.m_129880_(this.world);
            if (world.m_46749_(pos)) {
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof UniversalTraderBlockEntity) {
                    UniversalTraderBlockEntity traderEntity = (UniversalTraderBlockEntity)blockEntity;
                    return traderEntity.getTraderID() == null || !traderEntity.getTraderID().equals(this.traderID);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final List<ItemStack> dumpContents(BlockState state, boolean dropBlock) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (dropBlock) {
            if (state.m_60734_() instanceof ITraderBlock) {
                contents.add(((ITraderBlock)state.m_60734_()).getDropBlockItem(state, this));
            } else {
                contents.add(new ItemStack((ItemLike)state.m_60734_()));
            }
        }
        contents.addAll(MoneyUtil.getCoinsOfValue(this.storedMoney));
        this.dumpContents(contents);
        return contents;
    }

    public static class TradeMenuProvider
    implements MenuProvider {
        private final UUID traderID;

        public TradeMenuProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }

        public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
            return new TraderMenu.TraderMenuUniversal(windowID, inventory, this.traderID);
        }
    }

    protected class DataWriter
    implements Consumer<FriendlyByteBuf> {
        final UUID traderID;

        public DataWriter(UUID traderID) {
            this.traderID = traderID;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.traderID);
        }
    }

    public static class StorageMenuProvider
    implements MenuProvider {
        private final UUID traderID;

        public StorageMenuProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }

        public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
            return new TraderStorageMenu.TraderStorageMenuUniversal(windowID, inventory, this.traderID);
        }
    }

    protected class TradeIndexDataWriter
    implements Consumer<FriendlyByteBuf> {
        final UUID traderID;
        final int tradeIndex;

        public TradeIndexDataWriter(UUID traderID, int tradeIndex) {
            this.traderID = traderID;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public void accept(FriendlyByteBuf buffer) {
            buffer.m_130077_(this.traderID);
            buffer.writeInt(this.tradeIndex);
        }
    }
}

