/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.blocks.TicketMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.networktraders.ItemTraderServerBlock;
import io.github.lightman314.lightmanscurrency.blocks.tradeinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinJarItem;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final RegistryObject<Block> COINPILE_COPPER = ModBlocks.register("coinpile_copper", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_COPPER.get())));
    public static final RegistryObject<Block> COINPILE_IRON = ModBlocks.register("coinpile_iron", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_IRON.get())));
    public static final RegistryObject<Block> COINPILE_GOLD = ModBlocks.register("coinpile_gold", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_GOLD.get())));
    public static final RegistryObject<Block> COINPILE_DIAMOND;
    public static final RegistryObject<Block> COINPILE_EMERALD;
    public static final RegistryObject<Block> COINPILE_NETHERITE;
    public static final RegistryObject<Block> COINBLOCK_COPPER;
    public static final RegistryObject<Block> COINBLOCK_IRON;
    public static final RegistryObject<Block> COINBLOCK_GOLD;
    public static final RegistryObject<Block> COINBLOCK_EMERALD;
    public static final RegistryObject<Block> COINBLOCK_DIAMOND;
    public static final RegistryObject<Block> COINBLOCK_NETHERITE;
    public static final RegistryObject<Block> MACHINE_ATM;
    public static final RegistryObject<Block> MACHINE_MINT;
    public static final RegistryObject<Block> DISPLAY_CASE;
    public static final RegistryObjectBundle<Block, Reference.Color> VENDING_MACHINE;
    public static final RegistryObjectBundle<Block, Reference.Color> VENDING_MACHINE_LARGE;
    public static final RegistryObjectBundle<Block, Reference.WoodType> SHELF;
    public static final RegistryObjectBundle<Block, Reference.WoodType> CARD_DISPLAY;
    public static final RegistryObject<Block> ARMOR_DISPLAY;
    public static final RegistryObject<Block> FREEZER;
    public static final RegistryObject<Block> ITEM_TRADER_SERVER_SMALL;
    public static final RegistryObject<Block> ITEM_TRADER_SERVER_MEDIUM;
    public static final RegistryObject<Block> ITEM_TRADER_SERVER_LARGE;
    public static final RegistryObject<Block> ITEM_TRADER_SERVER_EXTRA_LARGE;
    public static final RegistryObject<Block> ITEM_TRADER_INTERFACE;
    public static final RegistryObject<Block> CASH_REGISTER;
    public static final RegistryObject<Block> TERMINAL;
    public static final RegistryObject<Block> GEM_TERMINAL;
    public static final RegistryObject<Block> PAYGATE;
    public static final RegistryObject<Block> TICKET_KIOSK;
    public static final RegistryObject<Block> TICKET_MACHINE;
    public static final RegistryObject<Block> PIGGY_BANK;
    public static final RegistryObject<Block> COINJAR_BLUE;

    public static void init() {
    }

    private static BiFunction<Block, CreativeModeTab, Item> getDefaultGenerator() {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new BlockItem(block, properties);
        };
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinGenerator(boolean fireResistant) {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            if (fireResistant) {
                properties.m_41486_();
            }
            return new CoinBlockItem((Block)block, properties);
        };
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinJarGenerator() {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new CoinJarItem((Block)block, properties);
        };
    }

    private static RegistryObject<Block> register(String name, CreativeModeTab itemGroup, Supplier<Block> sup) {
        return ModBlocks.register(name, itemGroup, ModBlocks.getDefaultGenerator(), sup);
    }

    private static RegistryObject<Block> register(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get(), itemGroup));
        }
        return block;
    }

    private static RegistryObjectBundle<Block, Reference.Color> registerColored(String name, CreativeModeTab itemGroup, Supplier<Block> block, @Nullable Reference.Color dontNameThisColor) {
        return ModBlocks.registerColored(name, itemGroup, ModBlocks.getDefaultGenerator(), block, dontNameThisColor);
    }

    private static RegistryObjectBundle<Block, Reference.Color> registerColored(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> block, @Nullable Reference.Color dontNameThisColor) {
        RegistryObjectBundle<Block, Reference.Color> bundle = new RegistryObjectBundle<Block, Reference.Color>();
        for (Reference.Color color : Reference.Color.values()) {
            Object thisName = name;
            if (color != dontNameThisColor) {
                thisName = (String)thisName + "_" + color.toString().toLowerCase();
            }
            bundle.put(color, ModBlocks.register((String)thisName, itemGroup, itemGenerator, block));
        }
        return bundle.lock();
    }

    private static RegistryObjectBundle<Block, Reference.WoodType> registerWooden(String name, CreativeModeTab itemGroup, Supplier<Block> block) {
        return ModBlocks.registerWooden(name, itemGroup, ModBlocks.getDefaultGenerator(), block);
    }

    private static RegistryObjectBundle<Block, Reference.WoodType> registerWooden(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> block) {
        RegistryObjectBundle<Block, Reference.WoodType> bundle = new RegistryObjectBundle<Block, Reference.WoodType>();
        for (Reference.WoodType woodType : Reference.WoodType.values()) {
            String thisName = name + "_" + woodType.toString().toLowerCase();
            bundle.put(woodType, ModBlocks.register(thisName, itemGroup, itemGenerator, block));
        }
        return bundle.lock();
    }

    static {
        COINPILE_EMERALD = ModBlocks.register("coinpile_emerald", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_EMERALD.get())));
        COINPILE_DIAMOND = ModBlocks.register("coinpile_diamond", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_DIAMOND.get())));
        COINPILE_NETHERITE = ModBlocks.register("coinpile_netherite", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(true), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_NETHERITE.get())));
        COINBLOCK_COPPER = ModBlocks.register("coinblock_copper", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_COPPER.get())));
        COINBLOCK_IRON = ModBlocks.register("coinblock_iron", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_IRON.get())));
        COINBLOCK_GOLD = ModBlocks.register("coinblock_gold", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_GOLD.get())));
        COINBLOCK_EMERALD = ModBlocks.register("coinblock_emerald", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_EMERALD.get())));
        COINBLOCK_DIAMOND = ModBlocks.register("coinblock_diamond", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_DIAMOND.get())));
        COINBLOCK_NETHERITE = ModBlocks.register("coinblock_netherite", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(true), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), () -> ModItems.COIN_NETHERITE.get())));
        MACHINE_ATM = ModBlocks.register("atm", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new ATMBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_))));
        MACHINE_MINT = ModBlocks.register("coinmint", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new CoinMintBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_))));
        CASH_REGISTER = ModBlocks.register("cash_register", LightmansCurrency.MACHINE_GROUP, (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new CashRegisterItem((Block)block, properties);
        }, (Supplier<Block>)((Supplier)() -> new CashRegisterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0))));
        DISPLAY_CASE = ModBlocks.register("display_case", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new DisplayCaseBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_))));
        VENDING_MACHINE = ModBlocks.registerColored("vending_machine", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), Reference.Color.WHITE);
        VENDING_MACHINE_LARGE = ModBlocks.registerColored("vending_machine_large", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineLargeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), Reference.Color.WHITE);
        SHELF = ModBlocks.registerWooden("shelf", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY))));
        CARD_DISPLAY = ModBlocks.registerWooden("card_display", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new CardDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_))));
        FREEZER = ModBlocks.register("freezer", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new FreezerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ARMOR_DISPLAY = ModBlocks.register("armor_display", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ArmorDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        TICKET_KIOSK = ModBlocks.register("ticket_kiosk", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new TicketKioskBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ITEM_TRADER_SERVER_SMALL = ModBlocks.register("item_trader_server_sml", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 3)));
        ITEM_TRADER_SERVER_MEDIUM = ModBlocks.register("item_trader_server_med", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 6)));
        ITEM_TRADER_SERVER_LARGE = ModBlocks.register("item_trader_server_lrg", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 12)));
        ITEM_TRADER_SERVER_EXTRA_LARGE = ModBlocks.register("item_trader_server_xlrg", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 16)));
        ITEM_TRADER_INTERFACE = ModBlocks.register("item_trader_interface", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderInterfaceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        TERMINAL = ModBlocks.register("terminal", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0))));
        GEM_TERMINAL = ModBlocks.register("gem_terminal", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154655_), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0))));
        PAYGATE = ModBlocks.register("paygate", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new PaygateBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        TICKET_MACHINE = ModBlocks.register("ticket_machine", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new TicketMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_))));
        PIGGY_BANK = ModBlocks.register("piggy_bank", CreativeModeTab.f_40750_, ModBlocks.getCoinJarGenerator(), (Supplier<Block>)((Supplier)() -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0))));
        COINJAR_BLUE = ModBlocks.register("coinjar_blue", CreativeModeTab.f_40750_, ModBlocks.getCoinJarGenerator(), (Supplier<Block>)((Supplier)() -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0))));
    }
}

