/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.entity.merchant.villager.CustomProfessions;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class VillagerTradeManager {
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;

    public static List<VillagerTrades.ItemListing> getGenericWandererTrades() {
        return ImmutableList.of((Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD.get(), 1, (ItemLike)ModBlocks.MACHINE_ATM.get())), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get())), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.TERMINAL.get())));
    }

    public static List<VillagerTrades.ItemListing> getRareWandererTrades() {
        return ImmutableList.of((Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD.get(), 2, (ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)ModBlocks.DISPLAY_CASE.get())), (Object)((Object)new LazyTrade((ItemLike)ModItems.COIN_GOLD.get(), 4, (ItemLike)ModBlocks.ARMOR_DISPLAY.get())));
    }

    public static Map<Integer, List<VillagerTrades.ItemListing>> getBankerTrades() {
        return ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)((Object)new LazyTrade(2, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.MACHINE_MINT.get())), (Object)((Object)new LazyTrade(2, (ItemLike)ModItems.COIN_GOLD.get(), 1, (ItemLike)ModBlocks.MACHINE_ATM.get())), (Object)((Object)new LazyTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)ModBlocks.CASH_REGISTER.get())), (Object)((Object)new LazyTrade(1, (ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)ModItems.COIN_COPPER.get(), 8, (ItemLike)ModItems.TRADING_CORE.get()))), (Object)2, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemLike[]{(ItemLike)ModBlocks.SHELF.get(Reference.WoodType.OAK), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.BIRCH), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.SPRUCE), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.JUNGLE)}, 12, 5, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemLike[]{(ItemLike)ModBlocks.SHELF.get(Reference.WoodType.ACACIA), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.DARK_OAK), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.CRIMSON), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.WARPED)}, 12, 5, 0.05f), (Object)((Object)new LazyTrade(5, (ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)ModBlocks.DISPLAY_CASE.get()))), (Object)3, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), new ItemLike[]{(ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.OAK), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.BIRCH), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.SPRUCE), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.JUNGLE)}, 12, 10, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), new ItemLike[]{(ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.ACACIA), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.DARK_OAK), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.CRIMSON), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.WARPED)}, 12, 10, 0.05f), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 20, (ItemLike)ModBlocks.ARMOR_DISPLAY.get())), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 15, (ItemLike)ModBlocks.ITEM_TRADER_SERVER_SMALL.get())), (Object)((Object)new LazyTrade(10, (ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)ModBlocks.TERMINAL.get()))), (Object)4, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), (ItemLike[])ModBlocks.VENDING_MACHINE.getAll().toArray(new Block[0]), 12, 15, 0.05f), (Object)((Object)new LazyTrade(15, (ItemLike)ModItems.COIN_IRON.get(), 30, (ItemLike)ModBlocks.ITEM_TRADER_SERVER_MEDIUM.get())), (Object)((Object)new LazyTrade(20, (ItemLike)ModItems.COIN_IRON.get(), 30, (ItemLike)ModBlocks.FREEZER.get())), (Object)((Object)new LazyTrade(20, (ItemLike)ModItems.COIN_DIAMOND.get(), 15, EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.MONEY_MENDING.get(), 1))))), (Object)5, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 25), (ItemLike[])ModBlocks.VENDING_MACHINE_LARGE.getAll().toArray(new Block[0]), 12, 30, 0.05f), (Object)((Object)new LazyTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 6, (ItemLike)ModBlocks.ITEM_TRADER_SERVER_LARGE.get())), (Object)((Object)new LazyTrade(30, (ItemLike)ModItems.COIN_GOLD.get(), 10, (ItemLike)ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE.get())), (Object)((Object)new LazyTrade(30, (ItemLike)ModItems.COIN_DIAMOND.get(), 10, EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.MONEY_MENDING.get(), 1))))));
    }

    public static Map<Integer, List<VillagerTrades.ItemListing>> getCashierTrades() {
        return ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42406_, 6), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.f_42458_), 16, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.f_42574_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 8), new ItemStack((ItemLike)Items.f_42412_, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.f_50078_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42676_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42451_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42470_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42471_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42468_), 12, 1, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42469_), 12, 1, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42386_), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 3, (ItemLike)Items.f_42383_, 12, 1, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42428_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42426_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42427_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get()), new ItemStack((ItemLike)Items.f_42429_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42699_), 12, 1, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42460_, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42687_, 4), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42410_, 4), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), new ItemStack((ItemLike)Items.f_42526_, 15), 16, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50683_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50041_), 16, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 4), new ItemStack((ItemLike)Items.f_42411_), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50681_), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 3), (TagKey<Structure>)StructureTags.f_215885_, "filled_map.monument", MapDecoration.Type.MONUMENT, 12, 5), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Items.f_42534_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), new ItemStack((ItemLike)Blocks.f_50680_), 12, 5, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 9), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42466_), 12, 5, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 3), new ItemStack((ItemLike)Items.f_42467_), 12, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42485_, 6), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Items.f_42582_, 8), 16, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50225_, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42572_, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 2, (ItemLike)Items.f_42523_, 3, 10, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)Items.f_42717_), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 3), new ItemStack((ItemLike)Blocks.f_50058_, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 4), (TagKey<Structure>)StructureTags.f_215884_, "filled_map.mansion", MapDecoration.Type.MANSION, 12, 10), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Blocks.f_50141_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 7), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 4), new ItemStack((ItemLike)Items.f_42464_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 10), new ItemStack((ItemLike)ModItems.COIN_COPPER.get(), 5), new ItemStack((ItemLike)Items.f_42465_), 12, 10, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 6), new ItemStack((ItemLike)Items.f_42740_), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.f_42386_, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 4, (ItemLike)Items.f_42384_, 3, 12, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 6, (ItemLike)Items.f_42385_, 3, 12, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_DIAMOND.get(), 2), new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 1), new ItemStack((ItemLike)Items.f_42392_), 3, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50387_, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50281_, 4), 16, 10, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50175_, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Blocks.f_50145_), 12, 15, 0.05f), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19611_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19603_, 160, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19613_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19610_, 120, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19614_, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), MobEffects.f_19618_, 7, 15), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 5, (ItemLike)Items.f_42411_, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 5), new ItemStack((ItemLike)Items.f_42524_), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42522_), 12, 15, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.f_42617_), 12, 15, 0.05f), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get()), new ItemStack((ItemLike)Items.f_42584_), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 7, (ItemLike)Items.f_42474_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 5, (ItemLike)Items.f_42475_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 3, (ItemLike)Items.f_42391_, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 2, (ItemLike)Items.f_42389_, 3, 15, 0.05f, 0.25), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50352_, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 15), new ItemStack((ItemLike)Items.f_42677_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 2), new ItemStack((ItemLike)Items.f_42546_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42487_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_IRON.get(), 10, (ItemLike)Items.f_42717_, 3, 15, 0.05f, 0.25), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42656_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_186364_), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_EMERALD.get(), 1), new ItemStack((ItemLike)Blocks.f_50200_, 12), 12, 30, 0.05f), (Object)new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 5), new ItemStack((ItemLike)Items.f_42612_), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 8, (ItemLike)Items.f_42473_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 6, (ItemLike)Items.f_42472_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42388_, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((ItemLike)ModItems.COIN_DIAMOND.get(), 4, (ItemLike)Items.f_42390_, 3, 30, 0.05f, 0.25), (Object[])new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_GOLD.get(), 1), new ItemStack((ItemLike)Items.f_42450_), 12, 30, 0.05f), new BasicItemListing(new ItemStack((ItemLike)ModItems.COIN_IRON.get(), 2), new ItemStack((ItemLike)Blocks.f_50333_), 12, 30, 0.05f)}));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnVillagerTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == CustomProfessions.BANKER.get()) {
            if (!((Boolean)Config.COMMON.addBankerVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering banker trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> bankerTrades = VillagerTradeManager.getBankerTrades();
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = bankerTrades.get(i);
                newTrades.forEach(trade -> currentTrades.add(trade));
            }
        } else if (event.getType() == CustomProfessions.CASHIER.get()) {
            if (!((Boolean)Config.COMMON.addCashierVillager.get()).booleanValue()) {
                return;
            }
            LightmansCurrency.LogInfo("Registering cashier trades.");
            Map<Integer, List<VillagerTrades.ItemListing>> cashierTrades = VillagerTradeManager.getCashierTrades();
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ItemListing> newTrades = cashierTrades.get(i);
                newTrades.forEach(trade -> currentTrades.add(trade));
            }
        } else {
            ResourceLocation type = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)event.getType());
            if (type.m_135827_().equals("minecraft")) {
                if (!((Boolean)Config.COMMON.changeVanillaTrades.get()).booleanValue()) {
                    return;
                }
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + type + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            } else if (((Boolean)Config.COMMON.changeModdedTrades.get()).booleanValue()) {
                LightmansCurrency.LogInfo("Replacing Emeralds for villager type '" + type + "'.");
                VillagerTradeManager.replaceExistingTrades(type.toString(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
            }
        }
    }

    private static void replaceExistingTrades(String trader, Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        Item replacementItem = Config.getEmeraldReplacementItem(trader);
        for (int i = 1; i <= 5; ++i) {
            List tradeList = (List)trades.get(i);
            ArrayList<ConvertedTrade> newList = new ArrayList<ConvertedTrade>();
            for (VillagerTrades.ItemListing trade : tradeList) {
                if (trade == null) continue;
                newList.add(new ConvertedTrade(trade, (ItemLike)Items.f_42616_, (ItemLike)replacementItem));
            }
            trades.put(i, newList);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void OnWandererTradeSetup(WandererTradesEvent event) {
        if (((Boolean)Config.COMMON.changeWanderingTrades.get()).booleanValue()) {
            VillagerTradeManager.replaceExistingTrades(event.getGenericTrades());
            VillagerTradeManager.replaceExistingTrades(event.getRareTrades());
        }
        if (((Boolean)Config.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            event.getGenericTrades().addAll(VillagerTradeManager.getGenericWandererTrades());
            event.getRareTrades().addAll(VillagerTradeManager.getRareWandererTrades());
        }
    }

    private static void replaceExistingTrades(List<VillagerTrades.ItemListing> tradeList) {
        Item replacementItem = Config.getDefaultEmeraldReplacementItem();
        for (int i = 0; i < tradeList.size(); ++i) {
            if (tradeList.get(i) == null) continue;
            tradeList.set(i, new ConvertedTrade(tradeList.get(i), (ItemLike)Items.f_42616_, (ItemLike)replacementItem));
        }
    }

    public static class LazyTrade
    extends BasicItemListing {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public LazyTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public LazyTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public LazyTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemStack forSaleItem) {
            super(new ItemStack(priceItem1, priceCount1), ItemStack.f_41583_, forSaleItem, 12, xpValue, 0.05f);
        }

        public LazyTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemStack forSaleItem) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), forSaleItem, 12, xpValue, 0.05f);
        }
    }

    public static class RandomItemForItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final ItemLike[] sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemForItemTrade(ItemStack price, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(ItemStack price1, ItemStack price2, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            int index = rand.m_188503_(this.sellItemOptions.length);
            ItemStack sellItem = new ItemStack(this.sellItemOptions[index]);
            return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    private static class EnchantedBookForCoinsTrade
    implements VillagerTrades.ItemListing {
        private static final Item baseCoin = (Item)ModItems.COIN_GOLD.get();
        private static final int baseCoinAmount = 5;
        private final int xpValue;

        public EnchantedBookForCoinsTrade(int xpValue) {
            this.xpValue = xpValue;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(Enchantment::m_6594_).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(rand.m_188503_(list.size()));
            int level = 1;
            if (enchantment.m_6586_() > 0) {
                level = rand.m_188503_(enchantment.m_6586_()) + 1;
            } else {
                LightmansCurrency.LogError("Enchantment of type '" + ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString() + "' has a max enchantment level of " + enchantment.m_6586_() + ". Unable to properly randomize the enchantment level for a villager trade. Will default to a level 1 enchantment.");
            }
            ItemStack itemstack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            long coinValue = MoneyUtil.getValue(baseCoin);
            long baseValue = coinValue * 5L;
            int valueRandom = rand.m_188503_(5 + level * 10);
            long value = baseValue + coinValue * (long)(level + valueRandom);
            if (enchantment.m_6591_()) {
                value *= 2L;
            }
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(value);
            ItemStack price1 = ItemStack.f_41583_;
            ItemStack price2 = ItemStack.f_41583_;
            if (coins.size() > 0) {
                price1 = coins.get(0);
            }
            if (coins.size() > 1) {
                price2 = coins.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedBookForCoinsTrade.getOffer() -> \nbaseValue=" + baseValue + "\ncoinValue=" + coinValue + "\nlevel=" + level + "\nvalueRandom=" + valueRandom + "\nvalue=" + value + "\nprice1=" + price1.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price1.m_41720_()) + "\nprice2=" + price2.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price2.m_41720_()));
            return new MerchantOffer(price1, price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    private static class EnchantedItemForCoinsTrade
    implements VillagerTrades.ItemListing {
        private final Item baseCoin;
        private final int baseCoinCount;
        private final Item sellItem;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;
        private final double basePriceModifier;

        private EnchantedItemForCoinsTrade(ItemLike baseCoin, int baseCoinCount, ItemLike sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
            this.baseCoin = baseCoin.m_5456_();
            this.baseCoinCount = baseCoinCount;
            this.sellItem = sellItem.m_5456_();
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
            this.basePriceModifier = basePriceModifier;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            int i = 5 + rand.m_188503_(15);
            ItemStack itemstack = EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)new ItemStack((ItemLike)this.sellItem), (int)i, (boolean)false);
            long coinValue = MoneyUtil.getValue(this.baseCoin);
            long baseValue = coinValue * (long)this.baseCoinCount;
            long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
            ItemStack price1 = ItemStack.f_41583_;
            ItemStack price2 = ItemStack.f_41583_;
            List<ItemStack> priceStacks = MoneyUtil.getCoinsOfValue(priceValue);
            if (priceStacks.size() > 0) {
                price1 = priceStacks.get(0);
            }
            if (priceStacks.size() > 1) {
                price2 = priceStacks.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedItemForCoinsTrade.getOffer() -> \ni=" + i + "\ncoinValue=" + coinValue + "\nbaseValue=" + baseValue + "\npriceValue=" + priceValue + "\nprice1=" + price1.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price1.m_41720_()) + "\nprice2=" + price2.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price2.m_41720_()));
            return new MerchantOffer(price1, price2, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class ItemsForMapTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public ItemsForMapTrade(ItemStack price, TagKey<Structure> destination, String displayName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this(price, ItemStack.f_41583_, destination, displayName, mapDecorationType, maxUses, xpValue);
        }

        public ItemsForMapTrade(ItemStack price1, ItemStack price2, TagKey<Structure> destination, String displayName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.destination = destination;
            this.displayName = displayName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverworld = (ServerLevel)trader.f_19853_;
            BlockPos blockPos = serverworld.m_215011_(this.destination, trader.m_20183_(), 100, true);
            if (blockPos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverworld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42897_((Level)serverworld, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
                return new MerchantOffer(this.price1, this.price2, itemstack, this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    private static class SuspiciousStewForItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack price1;
        private final ItemStack price2;
        private final MobEffect effect;
        private final int duration;
        private final int xpValue;

        private SuspiciousStewForItemTrade(ItemStack price, MobEffect effect, int duration, int xpValue) {
            this(price, ItemStack.f_41583_, effect, duration, xpValue);
        }

        private SuspiciousStewForItemTrade(ItemStack price1, ItemStack price2, MobEffect effect, int duration, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.effect = effect;
            this.duration = duration;
            this.xpValue = xpValue;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)itemstack, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(this.price1, this.price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    public static class ConvertedTrade
    implements VillagerTrades.ItemListing {
        final VillagerTrades.ItemListing tradeSource;
        final ItemLike oldItem;
        final ItemLike newItem;

        public ConvertedTrade(VillagerTrades.ItemListing tradeSource, ItemLike oldItem, ItemLike newItem) {
            this.tradeSource = tradeSource;
            this.oldItem = oldItem;
            this.newItem = newItem;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            try {
                int attempts = 0;
                MerchantOffer offer = null;
                while ((offer = this.tradeSource.m_213663_(trader, random)) == null && attempts++ < 100) {
                }
                if (attempts > 1) {
                    if (offer == null) {
                        LightmansCurrency.LogError("Original Item Listing Class: " + this.tradeSource.getClass().getName());
                        throw new NullPointerException("The original Item Listing of the converted trade returned a null trade offer " + attempts + " times!");
                    }
                    LightmansCurrency.LogWarning("Original Item Listing Class: " + this.tradeSource.getClass().getName());
                    LightmansCurrency.LogWarning("Converted Trade took " + attempts + " attempts to receive a non-null trade offer from the original Item Listing!");
                }
                ItemStack itemA = offer.m_45352_();
                ItemStack itemB = offer.m_45364_();
                ItemStack itemC = offer.m_45368_();
                if (itemA.m_41720_() == this.oldItem) {
                    itemA = new ItemStack(this.newItem, itemA.m_41613_());
                }
                if (itemB.m_41720_() == this.oldItem) {
                    itemB = new ItemStack(this.newItem, itemB.m_41613_());
                }
                if (itemC.m_41720_() == this.oldItem) {
                    itemC = new ItemStack(this.newItem, itemC.m_41613_());
                }
                return new MerchantOffer(itemA, itemB, itemC, offer.m_45371_(), offer.m_45373_(), offer.m_45379_(), offer.m_45378_(), offer.m_45375_());
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error converting trade:", t);
                return null;
            }
        }
    }

    public static class SetTrade
    extends BasicItemListing {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public SetTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public SetTrade(ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public SetTrade(int xpValue, ItemLike priceItem, int priceCount, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public SetTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public SetTrade(ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public SetTrade(int xpValue, ItemLike priceItem1, int priceCount1, ItemLike priceItem2, int priceCount2, ItemLike forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }
    }
}

