/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CoinMintRecipeSerializer
implements RecipeSerializer<CoinMintRecipe> {
    public CoinMintRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an item.");
        }
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("ingredient"));
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result. Expected to find an item.");
        }
        ItemStack result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("result").getAsString())));
        if (result.m_41619_()) {
            throw new JsonSyntaxException("Result is empty.");
        }
        CoinMintRecipe.MintType type = CoinMintRecipe.MintType.OTHER;
        if (json.has("mintType")) {
            type = CoinMintRecipe.readType(json.get("mintType"));
        }
        return new CoinMintRecipe(recipeId, type, ingredient, (ItemLike)result.m_41720_());
    }

    public CoinMintRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        CoinMintRecipe.MintType type = CoinMintRecipe.readType(buffer.m_130277_());
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        return new CoinMintRecipe(recipeId, type, ingredient, (ItemLike)result.m_41720_());
    }

    public void toNetwork(FriendlyByteBuf buffer, CoinMintRecipe recipe) {
        buffer.m_130070_(recipe.getMintType().name());
        recipe.getIngredient().m_43923_(buffer);
        buffer.writeItemStack(recipe.getResult(), false);
    }
}

